/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelSpotInstanceRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelSpotInstanceRequestsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelSpotInstanceRequestsRequest.Builder, CancelSpotInstanceRequestsRequest> {
    private final List<String> spotInstanceRequestIds;

    private CancelSpotInstanceRequestsRequest(BuilderImpl builder) {
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
    }

    /**
     * <p>
     * One or more Spot instance request IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Spot instance request IDs.
     */
    public List<String> spotInstanceRequestIds() {
        return spotInstanceRequestIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((spotInstanceRequestIds() == null) ? 0 : spotInstanceRequestIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsRequest)) {
            return false;
        }
        CancelSpotInstanceRequestsRequest other = (CancelSpotInstanceRequestsRequest) obj;
        if (other.spotInstanceRequestIds() == null ^ this.spotInstanceRequestIds() == null) {
            return false;
        }
        if (other.spotInstanceRequestIds() != null && !other.spotInstanceRequestIds().equals(this.spotInstanceRequestIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (spotInstanceRequestIds() != null) {
            sb.append("SpotInstanceRequestIds: ").append(spotInstanceRequestIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotInstanceRequestIds":
            return Optional.of(clazz.cast(spotInstanceRequestIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
        /**
         * <p>
         * One or more Spot instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds);

        /**
         * <p>
         * One or more Spot instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(String... spotInstanceRequestIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> spotInstanceRequestIds;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsRequest model) {
            spotInstanceRequestIds(model.spotInstanceRequestIds);
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            return spotInstanceRequestIds;
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String... spotInstanceRequestIds) {
            spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        @Override
        public CancelSpotInstanceRequestsRequest build() {
            return new CancelSpotInstanceRequestsRequest(this);
        }
    }
}
