/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * VolumeStatusItem StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VolumeStatusItemUnmarshaller implements Unmarshaller<VolumeStatusItem, StaxUnmarshallerContext> {

    public VolumeStatusItem unmarshall(StaxUnmarshallerContext context) throws Exception {
        VolumeStatusItem.Builder volumeStatusItem = VolumeStatusItem.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<VolumeStatusAction> actions = null;
        java.util.List<VolumeStatusEvent> events = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                volumeStatusItem.actions(actions);
                volumeStatusItem.events(events);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("actionsSet", targetDepth)) {
                    actions = new ArrayList<VolumeStatusAction>();
                    continue;
                }

                if (context.testExpression("actionsSet/item", targetDepth)) {
                    actions.add(VolumeStatusActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availabilityZone", targetDepth)) {
                    volumeStatusItem.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("eventsSet", targetDepth)) {
                    events = new ArrayList<VolumeStatusEvent>();
                    continue;
                }

                if (context.testExpression("eventsSet/item", targetDepth)) {
                    events.add(VolumeStatusEventUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("volumeId", targetDepth)) {
                    volumeStatusItem.volumeId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("volumeStatus", targetDepth)) {
                    volumeStatusItem.volumeStatus(VolumeStatusInfoUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    volumeStatusItem.actions(actions);
                    volumeStatusItem.events(events);
                    break;
                }
            }
        }
        return volumeStatusItem.build();
    }

    private static final VolumeStatusItemUnmarshaller INSTANCE = new VolumeStatusItemUnmarshaller();

    public static VolumeStatusItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}
