/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * SnapshotDetail StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SnapshotDetailUnmarshaller implements Unmarshaller<SnapshotDetail, StaxUnmarshallerContext> {

    public SnapshotDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        SnapshotDetail.Builder snapshotDetail = SnapshotDetail.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("description", targetDepth)) {
                    snapshotDetail.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("deviceName", targetDepth)) {
                    snapshotDetail.deviceName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("diskImageSize", targetDepth)) {
                    snapshotDetail.diskImageSize(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("format", targetDepth)) {
                    snapshotDetail.format(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("progress", targetDepth)) {
                    snapshotDetail.progress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("snapshotId", targetDepth)) {
                    snapshotDetail.snapshotId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("status", targetDepth)) {
                    snapshotDetail.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("statusMessage", targetDepth)) {
                    snapshotDetail.statusMessage(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("url", targetDepth)) {
                    snapshotDetail.url(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("userBucket", targetDepth)) {
                    snapshotDetail.userBucket(UserBucketDetailsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return snapshotDetail.build();
    }

    private static final SnapshotDetailUnmarshaller INSTANCE = new SnapshotDetailUnmarshaller();

    public static SnapshotDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}
