/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ScheduledInstancesLaunchSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ScheduledInstancesLaunchSpecificationUnmarshaller implements
        Unmarshaller<ScheduledInstancesLaunchSpecification, StaxUnmarshallerContext> {

    public ScheduledInstancesLaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScheduledInstancesLaunchSpecification.Builder scheduledInstancesLaunchSpecification = ScheduledInstancesLaunchSpecification
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings = null;
        java.util.List<ScheduledInstancesNetworkInterface> networkInterfaces = null;
        java.util.List<String> securityGroupIds = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                scheduledInstancesLaunchSpecification.blockDeviceMappings(blockDeviceMappings);
                scheduledInstancesLaunchSpecification.networkInterfaces(networkInterfaces);
                scheduledInstancesLaunchSpecification.securityGroupIds(securityGroupIds);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("BlockDeviceMapping", targetDepth)) {
                    blockDeviceMappings = new ArrayList<ScheduledInstancesBlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("BlockDeviceMapping/BlockDeviceMapping", targetDepth)) {
                    blockDeviceMappings.add(ScheduledInstancesBlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EbsOptimized", targetDepth)) {
                    scheduledInstancesLaunchSpecification.ebsOptimized(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IamInstanceProfile", targetDepth)) {
                    scheduledInstancesLaunchSpecification.iamInstanceProfile(ScheduledInstancesIamInstanceProfileUnmarshaller
                            .getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ImageId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.imageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InstanceType", targetDepth)) {
                    scheduledInstancesLaunchSpecification.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KernelId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KeyName", targetDepth)) {
                    scheduledInstancesLaunchSpecification.keyName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Monitoring", targetDepth)) {
                    scheduledInstancesLaunchSpecification.monitoring(ScheduledInstancesMonitoringUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("NetworkInterface", targetDepth)) {
                    networkInterfaces = new ArrayList<ScheduledInstancesNetworkInterface>();
                    continue;
                }

                if (context.testExpression("NetworkInterface/NetworkInterface", targetDepth)) {
                    networkInterfaces.add(ScheduledInstancesNetworkInterfaceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Placement", targetDepth)) {
                    scheduledInstancesLaunchSpecification.placement(ScheduledInstancesPlacementUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("RamdiskId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SecurityGroupId", targetDepth)) {
                    securityGroupIds = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("SecurityGroupId/SecurityGroupId", targetDepth)) {
                    securityGroupIds.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SubnetId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("UserData", targetDepth)) {
                    scheduledInstancesLaunchSpecification.userData(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    scheduledInstancesLaunchSpecification.blockDeviceMappings(blockDeviceMappings);
                    scheduledInstancesLaunchSpecification.networkInterfaces(networkInterfaces);
                    scheduledInstancesLaunchSpecification.securityGroupIds(securityGroupIds);
                    break;
                }
            }
        }
        return scheduledInstancesLaunchSpecification.build();
    }

    private static final ScheduledInstancesLaunchSpecificationUnmarshaller INSTANCE = new ScheduledInstancesLaunchSpecificationUnmarshaller();

    public static ScheduledInstancesLaunchSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
