/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ScheduledInstance StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ScheduledInstanceUnmarshaller implements Unmarshaller<ScheduledInstance, StaxUnmarshallerContext> {

    public ScheduledInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScheduledInstance.Builder scheduledInstance = ScheduledInstance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("availabilityZone", targetDepth)) {
                    scheduledInstance.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("createDate", targetDepth)) {
                    scheduledInstance.createDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hourlyPrice", targetDepth)) {
                    scheduledInstance.hourlyPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceCount", targetDepth)) {
                    scheduledInstance.instanceCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    scheduledInstance.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkPlatform", targetDepth)) {
                    scheduledInstance.networkPlatform(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextSlotStartTime", targetDepth)) {
                    scheduledInstance.nextSlotStartTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("platform", targetDepth)) {
                    scheduledInstance.platform(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("previousSlotEndTime", targetDepth)) {
                    scheduledInstance.previousSlotEndTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("recurrence", targetDepth)) {
                    scheduledInstance.recurrence(ScheduledInstanceRecurrenceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("scheduledInstanceId", targetDepth)) {
                    scheduledInstance.scheduledInstanceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("slotDurationInHours", targetDepth)) {
                    scheduledInstance.slotDurationInHours(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("termEndDate", targetDepth)) {
                    scheduledInstance.termEndDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("termStartDate", targetDepth)) {
                    scheduledInstance.termStartDate(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("totalScheduledInstanceHours", targetDepth)) {
                    scheduledInstance.totalScheduledInstanceHours(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return scheduledInstance.build();
    }

    private static final ScheduledInstanceUnmarshaller INSTANCE = new ScheduledInstanceUnmarshaller();

    public static ScheduledInstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
