/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ScheduledInstanceRecurrence StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ScheduledInstanceRecurrenceUnmarshaller implements
        Unmarshaller<ScheduledInstanceRecurrence, StaxUnmarshallerContext> {

    public ScheduledInstanceRecurrence unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScheduledInstanceRecurrence.Builder scheduledInstanceRecurrence = ScheduledInstanceRecurrence.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Integer> occurrenceDaySet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                scheduledInstanceRecurrence.occurrenceDaySet(occurrenceDaySet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("frequency", targetDepth)) {
                    scheduledInstanceRecurrence.frequency(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("interval", targetDepth)) {
                    scheduledInstanceRecurrence.interval(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("occurrenceDaySet", targetDepth)) {
                    occurrenceDaySet = new ArrayList<Integer>();
                    continue;
                }

                if (context.testExpression("occurrenceDaySet/item", targetDepth)) {
                    occurrenceDaySet.add(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("occurrenceRelativeToEnd", targetDepth)) {
                    scheduledInstanceRecurrence.occurrenceRelativeToEnd(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("occurrenceUnit", targetDepth)) {
                    scheduledInstanceRecurrence.occurrenceUnit(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    scheduledInstanceRecurrence.occurrenceDaySet(occurrenceDaySet);
                    break;
                }
            }
        }
        return scheduledInstanceRecurrence.build();
    }

    private static final ScheduledInstanceRecurrenceUnmarshaller INSTANCE = new ScheduledInstanceRecurrenceUnmarshaller();

    public static ScheduledInstanceRecurrenceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
