/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * RunInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RunInstancesRequestMarshaller implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {

    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {

        if (runInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<RunInstancesRequest> request = new DefaultRequest<RunInstancesRequest>(runInstancesRequest, "EC2Client");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<BlockDeviceMapping> runInstancesRequestBlockDeviceMappingsList = runInstancesRequest.blockDeviceMappings();
        if (runInstancesRequestBlockDeviceMappingsList != null) {
            int blockDeviceMappingsListIndex = 1;

            for (BlockDeviceMapping runInstancesRequestBlockDeviceMappingsListValue : runInstancesRequestBlockDeviceMappingsList) {

                if (runInstancesRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName",
                            StringUtils.fromString(runInstancesRequestBlockDeviceMappingsListValue.deviceName()));
                }

                if (runInstancesRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName",
                            StringUtils.fromString(runInstancesRequestBlockDeviceMappingsListValue.virtualName()));
                }

                EbsBlockDevice ebs = runInstancesRequestBlockDeviceMappingsListValue.ebs();
                if (ebs != null) {

                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted",
                                StringUtils.fromBoolean(ebs.encrypted()));
                    }

                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination",
                                StringUtils.fromBoolean(ebs.deleteOnTermination()));
                    }

                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops",
                                StringUtils.fromInteger(ebs.iops()));
                    }

                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId",
                                StringUtils.fromString(ebs.snapshotId()));
                    }

                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize",
                                StringUtils.fromInteger(ebs.volumeSize()));
                    }

                    if (ebs.volumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType",
                                StringUtils.fromString(ebs.volumeType()));
                    }
                }

                if (runInstancesRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice",
                            StringUtils.fromString(runInstancesRequestBlockDeviceMappingsListValue.noDevice()));
                }
                blockDeviceMappingsListIndex++;
            }
        }

        if (runInstancesRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(runInstancesRequest.imageId()));
        }

        if (runInstancesRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(runInstancesRequest.instanceType()));
        }

        if (runInstancesRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger(runInstancesRequest.ipv6AddressCount()));
        }

        java.util.List<InstanceIpv6Address> runInstancesRequestIpv6AddressesList = runInstancesRequest.ipv6Addresses();
        if (runInstancesRequestIpv6AddressesList != null) {
            int ipv6AddressesListIndex = 1;

            for (InstanceIpv6Address runInstancesRequestIpv6AddressesListValue : runInstancesRequestIpv6AddressesList) {

                if (runInstancesRequestIpv6AddressesListValue.ipv6Address() != null) {
                    request.addParameter("Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address",
                            StringUtils.fromString(runInstancesRequestIpv6AddressesListValue.ipv6Address()));
                }
                ipv6AddressesListIndex++;
            }
        }

        if (runInstancesRequest.kernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(runInstancesRequest.kernelId()));
        }

        if (runInstancesRequest.keyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(runInstancesRequest.keyName()));
        }

        if (runInstancesRequest.maxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger(runInstancesRequest.maxCount()));
        }

        if (runInstancesRequest.minCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger(runInstancesRequest.minCount()));
        }

        if (runInstancesRequest.monitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean(runInstancesRequest.monitoring()));
        }

        Placement placement = runInstancesRequest.placement();
        if (placement != null) {

            if (placement.availabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString(placement.availabilityZone()));
            }

            if (placement.affinity() != null) {
                request.addParameter("Placement.Affinity", StringUtils.fromString(placement.affinity()));
            }

            if (placement.groupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString(placement.groupName()));
            }

            if (placement.hostId() != null) {
                request.addParameter("Placement.HostId", StringUtils.fromString(placement.hostId()));
            }

            if (placement.tenancy() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString(placement.tenancy()));
            }

            if (placement.spreadDomain() != null) {
                request.addParameter("Placement.SpreadDomain", StringUtils.fromString(placement.spreadDomain()));
            }
        }

        if (runInstancesRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(runInstancesRequest.ramdiskId()));
        }

        java.util.List<String> runInstancesRequestSecurityGroupIdsList = runInstancesRequest.securityGroupIds();
        if (runInstancesRequestSecurityGroupIdsList != null) {
            int securityGroupIdsListIndex = 1;

            for (String runInstancesRequestSecurityGroupIdsListValue : runInstancesRequestSecurityGroupIdsList) {
                if (runInstancesRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex,
                            StringUtils.fromString(runInstancesRequestSecurityGroupIdsListValue));
                }
                securityGroupIdsListIndex++;
            }
        }

        java.util.List<String> runInstancesRequestSecurityGroupsList = runInstancesRequest.securityGroups();
        if (runInstancesRequestSecurityGroupsList != null) {
            int securityGroupsListIndex = 1;

            for (String runInstancesRequestSecurityGroupsListValue : runInstancesRequestSecurityGroupsList) {
                if (runInstancesRequestSecurityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex,
                            StringUtils.fromString(runInstancesRequestSecurityGroupsListValue));
                }
                securityGroupsListIndex++;
            }
        }

        if (runInstancesRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(runInstancesRequest.subnetId()));
        }

        if (runInstancesRequest.userData() != null) {
            request.addParameter("UserData", StringUtils.fromString(runInstancesRequest.userData()));
        }

        if (runInstancesRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString(runInstancesRequest.additionalInfo()));
        }

        if (runInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(runInstancesRequest.clientToken()));
        }

        if (runInstancesRequest.disableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean(runInstancesRequest.disableApiTermination()));
        }

        if (runInstancesRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean(runInstancesRequest.ebsOptimized()));
        }

        IamInstanceProfileSpecification iamInstanceProfile = runInstancesRequest.iamInstanceProfile();
        if (iamInstanceProfile != null) {

            if (iamInstanceProfile.arn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.arn()));
            }

            if (iamInstanceProfile.name() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.name()));
            }
        }

        if (runInstancesRequest.instanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior",
                    StringUtils.fromString(runInstancesRequest.instanceInitiatedShutdownBehavior()));
        }

        java.util.List<InstanceNetworkInterfaceSpecification> runInstancesRequestNetworkInterfacesList = runInstancesRequest
                .networkInterfaces();
        if (runInstancesRequestNetworkInterfacesList != null) {
            int networkInterfacesListIndex = 1;

            for (InstanceNetworkInterfaceSpecification runInstancesRequestNetworkInterfacesListValue : runInstancesRequestNetworkInterfacesList) {

                if (runInstancesRequestNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress",
                            StringUtils.fromBoolean(runInstancesRequestNetworkInterfacesListValue.associatePublicIpAddress()));
                }

                if (runInstancesRequestNetworkInterfacesListValue.deleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination",
                            StringUtils.fromBoolean(runInstancesRequestNetworkInterfacesListValue.deleteOnTermination()));
                }

                if (runInstancesRequestNetworkInterfacesListValue.description() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description",
                            StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.description()));
                }

                if (runInstancesRequestNetworkInterfacesListValue.deviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex",
                            StringUtils.fromInteger(runInstancesRequestNetworkInterfacesListValue.deviceIndex()));
                }

                java.util.List<String> instanceNetworkInterfaceSpecificationGroupsList = runInstancesRequestNetworkInterfacesListValue
                        .groups();
                if (instanceNetworkInterfaceSpecificationGroupsList != null) {
                    int groupsListIndex = 1;

                    for (String instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                        if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId."
                                    + groupsListIndex,
                                    StringUtils.fromString(instanceNetworkInterfaceSpecificationGroupsListValue));
                        }
                        groupsListIndex++;
                    }
                }

                if (runInstancesRequestNetworkInterfacesListValue.ipv6AddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount",
                            StringUtils.fromInteger(runInstancesRequestNetworkInterfacesListValue.ipv6AddressCount()));
                }

                java.util.List<InstanceIpv6Address> instanceNetworkInterfaceSpecificationIpv6AddressesList = runInstancesRequestNetworkInterfacesListValue
                        .ipv6Addresses();
                if (instanceNetworkInterfaceSpecificationIpv6AddressesList != null) {
                    int ipv6AddressesListIndex = 1;

                    for (InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue : instanceNetworkInterfaceSpecificationIpv6AddressesList) {

                        if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses."
                                    + ipv6AddressesListIndex + ".Ipv6Address", StringUtils
                                    .fromString(instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                        }
                        ipv6AddressesListIndex++;
                    }
                }

                if (runInstancesRequestNetworkInterfacesListValue.networkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId",
                            StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.networkInterfaceId()));
                }

                if (runInstancesRequestNetworkInterfacesListValue.privateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress",
                            StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.privateIpAddress()));
                }

                java.util.List<PrivateIpAddressSpecification> instanceNetworkInterfaceSpecificationPrivateIpAddressesList = runInstancesRequestNetworkInterfacesListValue
                        .privateIpAddresses();
                if (instanceNetworkInterfaceSpecificationPrivateIpAddressesList != null) {
                    int privateIpAddressesListIndex = 1;

                    for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {

                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses."
                                    + privateIpAddressesListIndex + ".Primary", StringUtils
                                    .fromBoolean(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                        }

                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses."
                                    + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils
                                    .fromString(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue
                                            .privateIpAddress()));
                        }
                        privateIpAddressesListIndex++;
                    }
                }

                if (runInstancesRequestNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount",
                            StringUtils.fromInteger(runInstancesRequestNetworkInterfacesListValue
                                    .secondaryPrivateIpAddressCount()));
                }

                if (runInstancesRequestNetworkInterfacesListValue.subnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId",
                            StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.subnetId()));
                }
                networkInterfacesListIndex++;
            }
        }

        if (runInstancesRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(runInstancesRequest.privateIpAddress()));
        }

        java.util.List<TagSpecification> runInstancesRequestTagSpecificationsList = runInstancesRequest.tagSpecifications();
        if (runInstancesRequestTagSpecificationsList != null) {
            int tagSpecificationsListIndex = 1;

            for (TagSpecification runInstancesRequestTagSpecificationsListValue : runInstancesRequestTagSpecificationsList) {

                if (runInstancesRequestTagSpecificationsListValue.resourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType",
                            StringUtils.fromString(runInstancesRequestTagSpecificationsListValue.resourceType()));
                }

                java.util.List<Tag> tagSpecificationTagsList = runInstancesRequestTagSpecificationsListValue.tags();
                if (tagSpecificationTagsList != null) {
                    int tagsListIndex = 1;

                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {

                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex
                                    + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.key()));
                        }

                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex
                                    + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.value()));
                        }
                        tagsListIndex++;
                    }
                }
                tagSpecificationsListIndex++;
            }
        }

        return request;
    }

}
