/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * ReportInstanceStatusRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReportInstanceStatusRequestMarshaller implements
        Marshaller<Request<ReportInstanceStatusRequest>, ReportInstanceStatusRequest> {

    public Request<ReportInstanceStatusRequest> marshall(ReportInstanceStatusRequest reportInstanceStatusRequest) {

        if (reportInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ReportInstanceStatusRequest> request = new DefaultRequest<ReportInstanceStatusRequest>(
                reportInstanceStatusRequest, "EC2Client");
        request.addParameter("Action", "ReportInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (reportInstanceStatusRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(reportInstanceStatusRequest.description()));
        }

        if (reportInstanceStatusRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant(reportInstanceStatusRequest.endTime()));
        }

        java.util.List<String> reportInstanceStatusRequestInstancesList = reportInstanceStatusRequest.instances();
        if (reportInstanceStatusRequestInstancesList != null) {
            int instancesListIndex = 1;

            for (String reportInstanceStatusRequestInstancesListValue : reportInstanceStatusRequestInstancesList) {
                if (reportInstanceStatusRequestInstancesListValue != null) {
                    request.addParameter("InstanceId." + instancesListIndex,
                            StringUtils.fromString(reportInstanceStatusRequestInstancesListValue));
                }
                instancesListIndex++;
            }
        }

        java.util.List<String> reportInstanceStatusRequestReasonCodesList = reportInstanceStatusRequest.reasonCodes();
        if (reportInstanceStatusRequestReasonCodesList != null) {
            int reasonCodesListIndex = 1;

            for (String reportInstanceStatusRequestReasonCodesListValue : reportInstanceStatusRequestReasonCodesList) {
                if (reportInstanceStatusRequestReasonCodesListValue != null) {
                    request.addParameter("ReasonCode." + reasonCodesListIndex,
                            StringUtils.fromString(reportInstanceStatusRequestReasonCodesListValue));
                }
                reasonCodesListIndex++;
            }
        }

        if (reportInstanceStatusRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant(reportInstanceStatusRequest.startTime()));
        }

        if (reportInstanceStatusRequest.status() != null) {
            request.addParameter("Status", StringUtils.fromString(reportInstanceStatusRequest.status()));
        }

        return request;
    }

}
