/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.IdempotentUtils;

/**
 * PurchaseScheduledInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PurchaseScheduledInstancesRequestMarshaller implements
        Marshaller<Request<PurchaseScheduledInstancesRequest>, PurchaseScheduledInstancesRequest> {

    public Request<PurchaseScheduledInstancesRequest> marshall(PurchaseScheduledInstancesRequest purchaseScheduledInstancesRequest) {

        if (purchaseScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PurchaseScheduledInstancesRequest> request = new DefaultRequest<PurchaseScheduledInstancesRequest>(
                purchaseScheduledInstancesRequest, "EC2Client");
        request.addParameter("Action", "PurchaseScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        request.addParameter("ClientToken", IdempotentUtils.resolveString(purchaseScheduledInstancesRequest.clientToken()));

        java.util.List<PurchaseRequest> purchaseScheduledInstancesRequestPurchaseRequestsList = purchaseScheduledInstancesRequest
                .purchaseRequests();
        if (purchaseScheduledInstancesRequestPurchaseRequestsList != null) {
            int purchaseRequestsListIndex = 1;

            for (PurchaseRequest purchaseScheduledInstancesRequestPurchaseRequestsListValue : purchaseScheduledInstancesRequestPurchaseRequestsList) {

                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.instanceCount() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".InstanceCount",
                            StringUtils.fromInteger(purchaseScheduledInstancesRequestPurchaseRequestsListValue.instanceCount()));
                }

                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.purchaseToken() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".PurchaseToken",
                            StringUtils.fromString(purchaseScheduledInstancesRequestPurchaseRequestsListValue.purchaseToken()));
                }
                purchaseRequestsListIndex++;
            }
        }

        return request;
    }

}
