/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * IpPermission StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class IpPermissionUnmarshaller implements Unmarshaller<IpPermission, StaxUnmarshallerContext> {

    public IpPermission unmarshall(StaxUnmarshallerContext context) throws Exception {
        IpPermission.Builder ipPermission = IpPermission.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Ipv6Range> ipv6Ranges = null;
        java.util.List<PrefixListId> prefixListIds = null;
        java.util.List<UserIdGroupPair> userIdGroupPairs = null;
        java.util.List<IpRange> ipv4Ranges = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                ipPermission.ipv6Ranges(ipv6Ranges);
                ipPermission.prefixListIds(prefixListIds);
                ipPermission.userIdGroupPairs(userIdGroupPairs);
                ipPermission.ipv4Ranges(ipv4Ranges);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("fromPort", targetDepth)) {
                    ipPermission.fromPort(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipProtocol", targetDepth)) {
                    ipPermission.ipProtocol(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6Ranges", targetDepth)) {
                    ipv6Ranges = new ArrayList<Ipv6Range>();
                    continue;
                }

                if (context.testExpression("ipv6Ranges/item", targetDepth)) {
                    ipv6Ranges.add(Ipv6RangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("prefixListIds", targetDepth)) {
                    prefixListIds = new ArrayList<PrefixListId>();
                    continue;
                }

                if (context.testExpression("prefixListIds/item", targetDepth)) {
                    prefixListIds.add(PrefixListIdUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("toPort", targetDepth)) {
                    ipPermission.toPort(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groups", targetDepth)) {
                    userIdGroupPairs = new ArrayList<UserIdGroupPair>();
                    continue;
                }

                if (context.testExpression("groups/item", targetDepth)) {
                    userIdGroupPairs.add(UserIdGroupPairUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipRanges", targetDepth)) {
                    ipv4Ranges = new ArrayList<IpRange>();
                    continue;
                }

                if (context.testExpression("ipRanges/item", targetDepth)) {
                    ipv4Ranges.add(IpRangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    ipPermission.ipv6Ranges(ipv6Ranges);
                    ipPermission.prefixListIds(prefixListIds);
                    ipPermission.userIdGroupPairs(userIdGroupPairs);
                    ipPermission.ipv4Ranges(ipv4Ranges);
                    break;
                }
            }
        }
        return ipPermission.build();
    }

    private static final IpPermissionUnmarshaller INSTANCE = new IpPermissionUnmarshaller();

    public static IpPermissionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
