/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * InstanceStatusSummary StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceStatusSummaryUnmarshaller implements Unmarshaller<InstanceStatusSummary, StaxUnmarshallerContext> {

    public InstanceStatusSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceStatusSummary.Builder instanceStatusSummary = InstanceStatusSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<InstanceStatusDetails> details = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                instanceStatusSummary.details(details);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("details", targetDepth)) {
                    details = new ArrayList<InstanceStatusDetails>();
                    continue;
                }

                if (context.testExpression("details/item", targetDepth)) {
                    details.add(InstanceStatusDetailsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("status", targetDepth)) {
                    instanceStatusSummary.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    instanceStatusSummary.details(details);
                    break;
                }
            }
        }
        return instanceStatusSummary.build();
    }

    private static final InstanceStatusSummaryUnmarshaller INSTANCE = new InstanceStatusSummaryUnmarshaller();

    public static InstanceStatusSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
