/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * ImportVolumeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImportVolumeRequestMarshaller implements Marshaller<Request<ImportVolumeRequest>, ImportVolumeRequest> {

    public Request<ImportVolumeRequest> marshall(ImportVolumeRequest importVolumeRequest) {

        if (importVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ImportVolumeRequest> request = new DefaultRequest<ImportVolumeRequest>(importVolumeRequest, "EC2Client");
        request.addParameter("Action", "ImportVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (importVolumeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(importVolumeRequest.availabilityZone()));
        }

        if (importVolumeRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(importVolumeRequest.description()));
        }

        DiskImageDetail image = importVolumeRequest.image();
        if (image != null) {

            if (image.bytes() != null) {
                request.addParameter("Image.Bytes", StringUtils.fromLong(image.bytes()));
            }

            if (image.format() != null) {
                request.addParameter("Image.Format", StringUtils.fromString(image.format()));
            }

            if (image.importManifestUrl() != null) {
                request.addParameter("Image.ImportManifestUrl", StringUtils.fromString(image.importManifestUrl()));
            }
        }

        VolumeDetail volume = importVolumeRequest.volume();
        if (volume != null) {

            if (volume.size() != null) {
                request.addParameter("Volume.Size", StringUtils.fromLong(volume.size()));
            }
        }

        return request;
    }

}
