/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ImportInstanceLaunchSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImportInstanceLaunchSpecificationUnmarshaller implements
        Unmarshaller<ImportInstanceLaunchSpecification, StaxUnmarshallerContext> {

    public ImportInstanceLaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        ImportInstanceLaunchSpecification.Builder importInstanceLaunchSpecification = ImportInstanceLaunchSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> groupIds = null;
        java.util.List<String> groupNames = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                importInstanceLaunchSpecification.groupIds(groupIds);
                importInstanceLaunchSpecification.groupNames(groupNames);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("additionalInfo", targetDepth)) {
                    importInstanceLaunchSpecification.additionalInfo(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("architecture", targetDepth)) {
                    importInstanceLaunchSpecification.architecture(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("GroupId", targetDepth)) {
                    groupIds = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("GroupId/SecurityGroupId", targetDepth)) {
                    groupIds.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("GroupName", targetDepth)) {
                    groupNames = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("GroupName/SecurityGroup", targetDepth)) {
                    groupNames.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceInitiatedShutdownBehavior", targetDepth)) {
                    importInstanceLaunchSpecification.instanceInitiatedShutdownBehavior(StringUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    importInstanceLaunchSpecification.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("monitoring/enabled", targetDepth)) {
                    importInstanceLaunchSpecification.monitoring(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("placement", targetDepth)) {
                    importInstanceLaunchSpecification.placement(PlacementUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddress", targetDepth)) {
                    importInstanceLaunchSpecification.privateIpAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    importInstanceLaunchSpecification.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("userData", targetDepth)) {
                    importInstanceLaunchSpecification.userData(UserDataUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    importInstanceLaunchSpecification.groupIds(groupIds);
                    importInstanceLaunchSpecification.groupNames(groupNames);
                    break;
                }
            }
        }
        return importInstanceLaunchSpecification.build();
    }

    private static final ImportInstanceLaunchSpecificationUnmarshaller INSTANCE = new ImportInstanceLaunchSpecificationUnmarshaller();

    public static ImportInstanceLaunchSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
