/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeStaleSecurityGroupsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeStaleSecurityGroupsRequestMarshaller implements
        Marshaller<Request<DescribeStaleSecurityGroupsRequest>, DescribeStaleSecurityGroupsRequest> {

    public Request<DescribeStaleSecurityGroupsRequest> marshall(
            DescribeStaleSecurityGroupsRequest describeStaleSecurityGroupsRequest) {

        if (describeStaleSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeStaleSecurityGroupsRequest> request = new DefaultRequest<DescribeStaleSecurityGroupsRequest>(
                describeStaleSecurityGroupsRequest, "EC2Client");
        request.addParameter("Action", "DescribeStaleSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeStaleSecurityGroupsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeStaleSecurityGroupsRequest.maxResults()));
        }

        if (describeStaleSecurityGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeStaleSecurityGroupsRequest.nextToken()));
        }

        if (describeStaleSecurityGroupsRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(describeStaleSecurityGroupsRequest.vpcId()));
        }

        return request;
    }

}
