/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribePrefixListsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribePrefixListsRequestMarshaller implements
        Marshaller<Request<DescribePrefixListsRequest>, DescribePrefixListsRequest> {

    public Request<DescribePrefixListsRequest> marshall(DescribePrefixListsRequest describePrefixListsRequest) {

        if (describePrefixListsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribePrefixListsRequest> request = new DefaultRequest<DescribePrefixListsRequest>(describePrefixListsRequest,
                "EC2Client");
        request.addParameter("Action", "DescribePrefixLists");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describePrefixListsRequestFiltersList = describePrefixListsRequest.filters();
        if (describePrefixListsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describePrefixListsRequestFiltersListValue : describePrefixListsRequestFiltersList) {

                if (describePrefixListsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describePrefixListsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describePrefixListsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describePrefixListsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describePrefixListsRequest.maxResults()));
        }

        if (describePrefixListsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describePrefixListsRequest.nextToken()));
        }

        java.util.List<String> describePrefixListsRequestPrefixListIdsList = describePrefixListsRequest.prefixListIds();
        if (describePrefixListsRequestPrefixListIdsList != null) {
            int prefixListIdsListIndex = 1;

            for (String describePrefixListsRequestPrefixListIdsListValue : describePrefixListsRequestPrefixListIdsList) {
                if (describePrefixListsRequestPrefixListIdsListValue != null) {
                    request.addParameter("PrefixListId." + prefixListIdsListIndex,
                            StringUtils.fromString(describePrefixListsRequestPrefixListIdsListValue));
                }
                prefixListIdsListIndex++;
            }
        }

        return request;
    }

}
