/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeNetworkAclsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNetworkAclsResponseUnmarshaller implements
        Unmarshaller<DescribeNetworkAclsResponse, StaxUnmarshallerContext> {

    public DescribeNetworkAclsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeNetworkAclsResponse.Builder describeNetworkAclsResponse = DescribeNetworkAclsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<NetworkAcl> networkAcls = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeNetworkAclsResponse.networkAcls(networkAcls);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("networkAclSet", targetDepth)) {
                    networkAcls = new ArrayList<NetworkAcl>();
                    continue;
                }

                if (context.testExpression("networkAclSet/item", targetDepth)) {
                    networkAcls.add(NetworkAclUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeNetworkAclsResponse.networkAcls(networkAcls);
                    break;
                }
            }
        }
        return describeNetworkAclsResponse.build();
    }

    private static final DescribeNetworkAclsResponseUnmarshaller INSTANCE = new DescribeNetworkAclsResponseUnmarshaller();

    public static DescribeNetworkAclsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
