/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeHostReservationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeHostReservationsResponseUnmarshaller implements
        Unmarshaller<DescribeHostReservationsResponse, StaxUnmarshallerContext> {

    public DescribeHostReservationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeHostReservationsResponse.Builder describeHostReservationsResponse = DescribeHostReservationsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<HostReservation> hostReservationSet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeHostReservationsResponse.hostReservationSet(hostReservationSet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("hostReservationSet", targetDepth)) {
                    hostReservationSet = new ArrayList<HostReservation>();
                    continue;
                }

                if (context.testExpression("hostReservationSet/member", targetDepth)) {
                    hostReservationSet.add(HostReservationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeHostReservationsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeHostReservationsResponse.hostReservationSet(hostReservationSet);
                    break;
                }
            }
        }
        return describeHostReservationsResponse.build();
    }

    private static final DescribeHostReservationsResponseUnmarshaller INSTANCE = new DescribeHostReservationsResponseUnmarshaller();

    public static DescribeHostReservationsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
