/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeHostReservationOfferingsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeHostReservationOfferingsResponseUnmarshaller implements
        Unmarshaller<DescribeHostReservationOfferingsResponse, StaxUnmarshallerContext> {

    public DescribeHostReservationOfferingsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeHostReservationOfferingsResponse.Builder describeHostReservationOfferingsResponse = DescribeHostReservationOfferingsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<HostOffering> offeringSet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeHostReservationOfferingsResponse.offeringSet(offeringSet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("nextToken", targetDepth)) {
                    describeHostReservationOfferingsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("offeringSet", targetDepth)) {
                    offeringSet = new ArrayList<HostOffering>();
                    continue;
                }

                if (context.testExpression("offeringSet/member", targetDepth)) {
                    offeringSet.add(HostOfferingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeHostReservationOfferingsResponse.offeringSet(offeringSet);
                    break;
                }
            }
        }
        return describeHostReservationOfferingsResponse.build();
    }

    private static final DescribeHostReservationOfferingsResponseUnmarshaller INSTANCE = new DescribeHostReservationOfferingsResponseUnmarshaller();

    public static DescribeHostReservationOfferingsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
