/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeCustomerGatewaysRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeCustomerGatewaysRequestMarshaller implements
        Marshaller<Request<DescribeCustomerGatewaysRequest>, DescribeCustomerGatewaysRequest> {

    public Request<DescribeCustomerGatewaysRequest> marshall(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {

        if (describeCustomerGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeCustomerGatewaysRequest> request = new DefaultRequest<DescribeCustomerGatewaysRequest>(
                describeCustomerGatewaysRequest, "EC2Client");
        request.addParameter("Action", "DescribeCustomerGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> describeCustomerGatewaysRequestCustomerGatewayIdsList = describeCustomerGatewaysRequest
                .customerGatewayIds();
        if (describeCustomerGatewaysRequestCustomerGatewayIdsList != null) {
            int customerGatewayIdsListIndex = 1;

            for (String describeCustomerGatewaysRequestCustomerGatewayIdsListValue : describeCustomerGatewaysRequestCustomerGatewayIdsList) {
                if (describeCustomerGatewaysRequestCustomerGatewayIdsListValue != null) {
                    request.addParameter("CustomerGatewayId." + customerGatewayIdsListIndex,
                            StringUtils.fromString(describeCustomerGatewaysRequestCustomerGatewayIdsListValue));
                }
                customerGatewayIdsListIndex++;
            }
        }

        java.util.List<Filter> describeCustomerGatewaysRequestFiltersList = describeCustomerGatewaysRequest.filters();
        if (describeCustomerGatewaysRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeCustomerGatewaysRequestFiltersListValue : describeCustomerGatewaysRequestFiltersList) {

                if (describeCustomerGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeCustomerGatewaysRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeCustomerGatewaysRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        return request;
    }

}
