/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * AvailableCapacity StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AvailableCapacityUnmarshaller implements Unmarshaller<AvailableCapacity, StaxUnmarshallerContext> {

    public AvailableCapacity unmarshall(StaxUnmarshallerContext context) throws Exception {
        AvailableCapacity.Builder availableCapacity = AvailableCapacity.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<InstanceCapacity> availableInstanceCapacity = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                availableCapacity.availableInstanceCapacity(availableInstanceCapacity);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("availableInstanceCapacity", targetDepth)) {
                    availableInstanceCapacity = new ArrayList<InstanceCapacity>();
                    continue;
                }

                if (context.testExpression("availableInstanceCapacity/item", targetDepth)) {
                    availableInstanceCapacity.add(InstanceCapacityUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availableVCpus", targetDepth)) {
                    availableCapacity.availableVCpus(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    availableCapacity.availableInstanceCapacity(availableInstanceCapacity);
                    break;
                }
            }
        }
        return availableCapacity.build();
    }

    private static final AvailableCapacityUnmarshaller INSTANCE = new AvailableCapacityUnmarshaller();

    public static AvailableCapacityUnmarshaller getInstance() {
        return INSTANCE;
    }
}
