/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * AccountAttribute StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AccountAttributeUnmarshaller implements Unmarshaller<AccountAttribute, StaxUnmarshallerContext> {

    public AccountAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccountAttribute.Builder accountAttribute = AccountAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<AccountAttributeValue> attributeValues = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                accountAttribute.attributeValues(attributeValues);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("attributeName", targetDepth)) {
                    accountAttribute.attributeName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("attributeValueSet", targetDepth)) {
                    attributeValues = new ArrayList<AccountAttributeValue>();
                    continue;
                }

                if (context.testExpression("attributeValueSet/item", targetDepth)) {
                    attributeValues.add(AccountAttributeValueUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    accountAttribute.attributeValues(attributeValues);
                    break;
                }
            }
        }
        return accountAttribute.build();
    }

    private static final AccountAttributeUnmarshaller INSTANCE = new AccountAttributeUnmarshaller();

    public static AccountAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
