/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPN connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnConnection implements ToCopyableBuilder<VpnConnection.Builder, VpnConnection> {
    private final String customerGatewayConfiguration;

    private final String customerGatewayId;

    private final String state;

    private final String type;

    private final String vpnConnectionId;

    private final String vpnGatewayId;

    private final VpnConnectionOptions options;

    private final List<VpnStaticRoute> routes;

    private final List<Tag> tags;

    private final List<VgwTelemetry> vgwTelemetry;

    private VpnConnection(BuilderImpl builder) {
        this.customerGatewayConfiguration = builder.customerGatewayConfiguration;
        this.customerGatewayId = builder.customerGatewayId;
        this.state = builder.state;
        this.type = builder.type;
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.options = builder.options;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vgwTelemetry = builder.vgwTelemetry;
    }

    /**
     * <p>
     * The configuration information for the VPN connection's customer gateway (in the native XML format). This element
     * is always present in the <a>CreateVpnConnection</a> response; however, it's present in the
     * <a>DescribeVpnConnections</a> response only if the VPN connection is in the <code>pending</code> or
     * <code>available</code> state.
     * </p>
     * 
     * @return The configuration information for the VPN connection's customer gateway (in the native XML format). This
     *         element is always present in the <a>CreateVpnConnection</a> response; however, it's present in the
     *         <a>DescribeVpnConnections</a> response only if the VPN connection is in the <code>pending</code> or
     *         <code>available</code> state.
     */
    public String customerGatewayConfiguration() {
        return customerGatewayConfiguration;
    }

    /**
     * <p>
     * The ID of the customer gateway at your end of the VPN connection.
     * </p>
     * 
     * @return The ID of the customer gateway at your end of the VPN connection.
     */
    public String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The current state of the VPN connection.
     * </p>
     * 
     * @return The current state of the VPN connection.
     * @see VpnState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The type of VPN connection.
     * </p>
     * 
     * @return The type of VPN connection.
     * @see GatewayType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The ID of the VPN connection.
     * </p>
     * 
     * @return The ID of the VPN connection.
     */
    public String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * <p>
     * The ID of the virtual private gateway at the AWS side of the VPN connection.
     * </p>
     * 
     * @return The ID of the virtual private gateway at the AWS side of the VPN connection.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * The VPN connection options.
     * </p>
     * 
     * @return The VPN connection options.
     */
    public VpnConnectionOptions options() {
        return options;
    }

    /**
     * <p>
     * The static routes associated with the VPN connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The static routes associated with the VPN connection.
     */
    public List<VpnStaticRoute> routes() {
        return routes;
    }

    /**
     * <p>
     * Any tags assigned to the VPN connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the VPN connection.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Information about the VPN tunnel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the VPN tunnel.
     */
    public List<VgwTelemetry> vgwTelemetry() {
        return vgwTelemetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((customerGatewayConfiguration() == null) ? 0 : customerGatewayConfiguration().hashCode());
        hashCode = 31 * hashCode + ((customerGatewayId() == null) ? 0 : customerGatewayId().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((vpnConnectionId() == null) ? 0 : vpnConnectionId().hashCode());
        hashCode = 31 * hashCode + ((vpnGatewayId() == null) ? 0 : vpnGatewayId().hashCode());
        hashCode = 31 * hashCode + ((options() == null) ? 0 : options().hashCode());
        hashCode = 31 * hashCode + ((routes() == null) ? 0 : routes().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((vgwTelemetry() == null) ? 0 : vgwTelemetry().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnection)) {
            return false;
        }
        VpnConnection other = (VpnConnection) obj;
        if (other.customerGatewayConfiguration() == null ^ this.customerGatewayConfiguration() == null) {
            return false;
        }
        if (other.customerGatewayConfiguration() != null
                && !other.customerGatewayConfiguration().equals(this.customerGatewayConfiguration())) {
            return false;
        }
        if (other.customerGatewayId() == null ^ this.customerGatewayId() == null) {
            return false;
        }
        if (other.customerGatewayId() != null && !other.customerGatewayId().equals(this.customerGatewayId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.vpnConnectionId() == null ^ this.vpnConnectionId() == null) {
            return false;
        }
        if (other.vpnConnectionId() != null && !other.vpnConnectionId().equals(this.vpnConnectionId())) {
            return false;
        }
        if (other.vpnGatewayId() == null ^ this.vpnGatewayId() == null) {
            return false;
        }
        if (other.vpnGatewayId() != null && !other.vpnGatewayId().equals(this.vpnGatewayId())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        if (other.routes() == null ^ this.routes() == null) {
            return false;
        }
        if (other.routes() != null && !other.routes().equals(this.routes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vgwTelemetry() == null ^ this.vgwTelemetry() == null) {
            return false;
        }
        if (other.vgwTelemetry() != null && !other.vgwTelemetry().equals(this.vgwTelemetry())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (customerGatewayConfiguration() != null) {
            sb.append("CustomerGatewayConfiguration: ").append(customerGatewayConfiguration()).append(",");
        }
        if (customerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(customerGatewayId()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (vpnConnectionId() != null) {
            sb.append("VpnConnectionId: ").append(vpnConnectionId()).append(",");
        }
        if (vpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(vpnGatewayId()).append(",");
        }
        if (options() != null) {
            sb.append("Options: ").append(options()).append(",");
        }
        if (routes() != null) {
            sb.append("Routes: ").append(routes()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (vgwTelemetry() != null) {
            sb.append("VgwTelemetry: ").append(vgwTelemetry()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VpnConnection> {
        /**
         * <p>
         * The configuration information for the VPN connection's customer gateway (in the native XML format). This
         * element is always present in the <a>CreateVpnConnection</a> response; however, it's present in the
         * <a>DescribeVpnConnections</a> response only if the VPN connection is in the <code>pending</code> or
         * <code>available</code> state.
         * </p>
         * 
         * @param customerGatewayConfiguration
         *        The configuration information for the VPN connection's customer gateway (in the native XML format).
         *        This element is always present in the <a>CreateVpnConnection</a> response; however, it's present in
         *        the <a>DescribeVpnConnections</a> response only if the VPN connection is in the <code>pending</code>
         *        or <code>available</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayConfiguration(String customerGatewayConfiguration);

        /**
         * <p>
         * The ID of the customer gateway at your end of the VPN connection.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway at your end of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The current state of the VPN connection.
         * </p>
         * 
         * @param state
         *        The current state of the VPN connection.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the VPN connection.
         * </p>
         * 
         * @param state
         *        The current state of the VPN connection.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(VpnState state);

        /**
         * <p>
         * The type of VPN connection.
         * </p>
         * 
         * @param type
         *        The type of VPN connection.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of VPN connection.
         * </p>
         * 
         * @param type
         *        The type of VPN connection.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(GatewayType type);

        /**
         * <p>
         * The ID of the VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The ID of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * <p>
         * The ID of the virtual private gateway at the AWS side of the VPN connection.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway at the AWS side of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * The VPN connection options.
         * </p>
         * 
         * @param options
         *        The VPN connection options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(VpnConnectionOptions options);

        /**
         * <p>
         * The static routes associated with the VPN connection.
         * </p>
         * 
         * @param routes
         *        The static routes associated with the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<VpnStaticRoute> routes);

        /**
         * <p>
         * The static routes associated with the VPN connection.
         * </p>
         * 
         * @param routes
         *        The static routes associated with the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(VpnStaticRoute... routes);

        /**
         * <p>
         * Any tags assigned to the VPN connection.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the VPN connection.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Information about the VPN tunnel.
         * </p>
         * 
         * @param vgwTelemetry
         *        Information about the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vgwTelemetry(Collection<VgwTelemetry> vgwTelemetry);

        /**
         * <p>
         * Information about the VPN tunnel.
         * </p>
         * 
         * @param vgwTelemetry
         *        Information about the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vgwTelemetry(VgwTelemetry... vgwTelemetry);
    }

    private static final class BuilderImpl implements Builder {
        private String customerGatewayConfiguration;

        private String customerGatewayId;

        private String state;

        private String type;

        private String vpnConnectionId;

        private String vpnGatewayId;

        private VpnConnectionOptions options;

        private List<VpnStaticRoute> routes;

        private List<Tag> tags;

        private List<VgwTelemetry> vgwTelemetry;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnection model) {
            setCustomerGatewayConfiguration(model.customerGatewayConfiguration);
            setCustomerGatewayId(model.customerGatewayId);
            setState(model.state);
            setType(model.type);
            setVpnConnectionId(model.vpnConnectionId);
            setVpnGatewayId(model.vpnGatewayId);
            setOptions(model.options);
            setRoutes(model.routes);
            setTags(model.tags);
            setVgwTelemetry(model.vgwTelemetry);
        }

        public final String getCustomerGatewayConfiguration() {
            return customerGatewayConfiguration;
        }

        @Override
        public final Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        public final void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final VpnConnectionOptions getOptions() {
            return options;
        }

        @Override
        public final Builder options(VpnConnectionOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptions options) {
            this.options = options;
        }

        public final Collection<VpnStaticRoute> getRoutes() {
            return routes;
        }

        @Override
        public final Builder routes(Collection<VpnStaticRoute> routes) {
            this.routes = VpnStaticRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(VpnStaticRoute... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        public final void setRoutes(Collection<VpnStaticRoute> routes) {
            this.routes = VpnStaticRouteListCopier.copy(routes);
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final Collection<VgwTelemetry> getVgwTelemetry() {
            return vgwTelemetry;
        }

        @Override
        public final Builder vgwTelemetry(Collection<VgwTelemetry> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copy(vgwTelemetry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(VgwTelemetry... vgwTelemetry) {
            vgwTelemetry(Arrays.asList(vgwTelemetry));
            return this;
        }

        public final void setVgwTelemetry(Collection<VgwTelemetry> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copy(vgwTelemetry);
        }

        @Override
        public VpnConnection build() {
            return new VpnConnection(this);
        }
    }
}
