/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC in a VPC peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcPeeringConnectionVpcInfo implements
        ToCopyableBuilder<VpcPeeringConnectionVpcInfo.Builder, VpcPeeringConnectionVpcInfo> {
    private final String cidrBlock;

    private final List<Ipv6CidrBlock> ipv6CidrBlockSet;

    private final String ownerId;

    private final VpcPeeringConnectionOptionsDescription peeringOptions;

    private final String vpcId;

    private VpcPeeringConnectionVpcInfo(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The IPv4 CIDR block for the VPC.
     * </p>
     * 
     * @return The IPv4 CIDR block for the VPC.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IPv6 CIDR block for the VPC.
     */
    public List<Ipv6CidrBlock> ipv6CidrBlockSet() {
        return ipv6CidrBlockSet;
    }

    /**
     * <p>
     * The AWS account ID of the VPC owner.
     * </p>
     * 
     * @return The AWS account ID of the VPC owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the accepter or requester VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the accepter or requester VPC.
     */
    public VpcPeeringConnectionOptionsDescription peeringOptions() {
        return peeringOptions;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrBlock() == null) ? 0 : cidrBlock().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlockSet() == null) ? 0 : ipv6CidrBlockSet().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((peeringOptions() == null) ? 0 : peeringOptions().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionVpcInfo)) {
            return false;
        }
        VpcPeeringConnectionVpcInfo other = (VpcPeeringConnectionVpcInfo) obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.ipv6CidrBlockSet() == null ^ this.ipv6CidrBlockSet() == null) {
            return false;
        }
        if (other.ipv6CidrBlockSet() != null && !other.ipv6CidrBlockSet().equals(this.ipv6CidrBlockSet())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.peeringOptions() == null ^ this.peeringOptions() == null) {
            return false;
        }
        if (other.peeringOptions() != null && !other.peeringOptions().equals(this.peeringOptions())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (ipv6CidrBlockSet() != null) {
            sb.append("Ipv6CidrBlockSet: ").append(ipv6CidrBlockSet()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (peeringOptions() != null) {
            sb.append("PeeringOptions: ").append(peeringOptions()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
        /**
         * <p>
         * The IPv4 CIDR block for the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(Ipv6CidrBlock... ipv6CidrBlockSet);

        /**
         * <p>
         * The AWS account ID of the VPC owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the VPC owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter or requester VPC.
         * </p>
         * 
         * @param peeringOptions
         *        Information about the VPC peering connection options for the accepter or requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private List<Ipv6CidrBlock> ipv6CidrBlockSet;

        private String ownerId;

        private VpcPeeringConnectionOptionsDescription peeringOptions;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionVpcInfo model) {
            setCidrBlock(model.cidrBlock);
            setIpv6CidrBlockSet(model.ipv6CidrBlockSet);
            setOwnerId(model.ownerId);
            setPeeringOptions(model.peeringOptions);
            setVpcId(model.vpcId);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Collection<Ipv6CidrBlock> getIpv6CidrBlockSet() {
            return ipv6CidrBlockSet;
        }

        @Override
        public final Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Ipv6CidrBlock... ipv6CidrBlockSet) {
            ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        public final void setIpv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copy(ipv6CidrBlockSet);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final VpcPeeringConnectionOptionsDescription getPeeringOptions() {
            return peeringOptions;
        }

        @Override
        public final Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final void setPeeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions) {
            this.peeringOptions = peeringOptions;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public VpcPeeringConnectionVpcInfo build() {
            return new VpcPeeringConnectionVpcInfo(this);
        }
    }
}
