/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume status event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusEvent implements ToCopyableBuilder<VolumeStatusEvent.Builder, VolumeStatusEvent> {
    private final String description;

    private final String eventId;

    private final String eventType;

    private final Instant notAfter;

    private final Instant notBefore;

    private VolumeStatusEvent(BuilderImpl builder) {
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
    }

    /**
     * <p>
     * A description of the event.
     * </p>
     * 
     * @return A description of the event.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of this event.
     * </p>
     * 
     * @return The ID of this event.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The type of this event.
     * </p>
     * 
     * @return The type of this event.
     */
    public String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The latest end time of the event.
     * </p>
     * 
     * @return The latest end time of the event.
     */
    public Instant notAfter() {
        return notAfter;
    }

    /**
     * <p>
     * The earliest start time of the event.
     * </p>
     * 
     * @return The earliest start time of the event.
     */
    public Instant notBefore() {
        return notBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((eventId() == null) ? 0 : eventId().hashCode());
        hashCode = 31 * hashCode + ((eventType() == null) ? 0 : eventType().hashCode());
        hashCode = 31 * hashCode + ((notAfter() == null) ? 0 : notAfter().hashCode());
        hashCode = 31 * hashCode + ((notBefore() == null) ? 0 : notBefore().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusEvent)) {
            return false;
        }
        VolumeStatusEvent other = (VolumeStatusEvent) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.eventType() == null ^ this.eventType() == null) {
            return false;
        }
        if (other.eventType() != null && !other.eventType().equals(this.eventType())) {
            return false;
        }
        if (other.notAfter() == null ^ this.notAfter() == null) {
            return false;
        }
        if (other.notAfter() != null && !other.notAfter().equals(this.notAfter())) {
            return false;
        }
        if (other.notBefore() == null ^ this.notBefore() == null) {
            return false;
        }
        if (other.notBefore() != null && !other.notBefore().equals(this.notBefore())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (eventId() != null) {
            sb.append("EventId: ").append(eventId()).append(",");
        }
        if (eventType() != null) {
            sb.append("EventType: ").append(eventType()).append(",");
        }
        if (notAfter() != null) {
            sb.append("NotAfter: ").append(notAfter()).append(",");
        }
        if (notBefore() != null) {
            sb.append("NotBefore: ").append(notBefore()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusEvent> {
        /**
         * <p>
         * A description of the event.
         * </p>
         * 
         * @param description
         *        A description of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of this event.
         * </p>
         * 
         * @param eventId
         *        The ID of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The type of this event.
         * </p>
         * 
         * @param eventType
         *        The type of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The latest end time of the event.
         * </p>
         * 
         * @param notAfter
         *        The latest end time of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfter(Instant notAfter);

        /**
         * <p>
         * The earliest start time of the event.
         * </p>
         * 
         * @param notBefore
         *        The earliest start time of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBefore(Instant notBefore);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private String eventId;

        private String eventType;

        private Instant notAfter;

        private Instant notBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusEvent model) {
            setDescription(model.description);
            setEventId(model.eventId);
            setEventType(model.eventType);
            setNotAfter(model.notAfter);
            setNotBefore(model.notBefore);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getNotAfter() {
            return notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public VolumeStatusEvent build() {
            return new VolumeStatusEvent(this);
        }
    }
}
