/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Subnet implements ToCopyableBuilder<Subnet.Builder, Subnet> {
    private final String availabilityZone;

    private final Integer availableIpAddressCount;

    private final String cidrBlock;

    private final Boolean defaultForAz;

    private final Boolean mapPublicIpOnLaunch;

    private final String state;

    private final String subnetId;

    private final String vpcId;

    private final Boolean assignIpv6AddressOnCreation;

    private final List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private final List<Tag> tags;

    private Subnet(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availableIpAddressCount = builder.availableIpAddressCount;
        this.cidrBlock = builder.cidrBlock;
        this.defaultForAz = builder.defaultForAz;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone of the subnet.
     * </p>
     * 
     * @return The Availability Zone of the subnet.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any stopped instances
     * are considered unavailable.
     * </p>
     * 
     * @return The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any stopped
     *         instances are considered unavailable.
     */
    public Integer availableIpAddressCount() {
        return availableIpAddressCount;
    }

    /**
     * <p>
     * The IPv4 CIDR block assigned to the subnet.
     * </p>
     * 
     * @return The IPv4 CIDR block assigned to the subnet.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Indicates whether this is the default subnet for the Availability Zone.
     * </p>
     * 
     * @return Indicates whether this is the default subnet for the Availability Zone.
     */
    public Boolean defaultForAz() {
        return defaultForAz;
    }

    /**
     * <p>
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     * </p>
     * 
     * @return Indicates whether instances launched in this subnet receive a public IPv4 address.
     */
    public Boolean mapPublicIpOnLaunch() {
        return mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * The current state of the subnet.
     * </p>
     * 
     * @return The current state of the subnet.
     * @see SubnetState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the VPC the subnet is in.
     * </p>
     * 
     * @return The ID of the VPC the subnet is in.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Indicates whether a network interface created in this subnet (including a network interface created by
     * <a>RunInstances</a>) receives an IPv6 address.
     * </p>
     * 
     * @return Indicates whether a network interface created in this subnet (including a network interface created by
     *         <a>RunInstances</a>) receives an IPv6 address.
     */
    public Boolean assignIpv6AddressOnCreation() {
        return assignIpv6AddressOnCreation;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR blocks associated with the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the IPv6 CIDR blocks associated with the subnet.
     */
    public List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    /**
     * <p>
     * Any tags assigned to the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the subnet.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((availableIpAddressCount() == null) ? 0 : availableIpAddressCount().hashCode());
        hashCode = 31 * hashCode + ((cidrBlock() == null) ? 0 : cidrBlock().hashCode());
        hashCode = 31 * hashCode + ((defaultForAz() == null) ? 0 : defaultForAz().hashCode());
        hashCode = 31 * hashCode + ((mapPublicIpOnLaunch() == null) ? 0 : mapPublicIpOnLaunch().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((assignIpv6AddressOnCreation() == null) ? 0 : assignIpv6AddressOnCreation().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlockAssociationSet() == null) ? 0 : ipv6CidrBlockAssociationSet().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.availableIpAddressCount() == null ^ this.availableIpAddressCount() == null) {
            return false;
        }
        if (other.availableIpAddressCount() != null && !other.availableIpAddressCount().equals(this.availableIpAddressCount())) {
            return false;
        }
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.defaultForAz() == null ^ this.defaultForAz() == null) {
            return false;
        }
        if (other.defaultForAz() != null && !other.defaultForAz().equals(this.defaultForAz())) {
            return false;
        }
        if (other.mapPublicIpOnLaunch() == null ^ this.mapPublicIpOnLaunch() == null) {
            return false;
        }
        if (other.mapPublicIpOnLaunch() != null && !other.mapPublicIpOnLaunch().equals(this.mapPublicIpOnLaunch())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.assignIpv6AddressOnCreation() == null ^ this.assignIpv6AddressOnCreation() == null) {
            return false;
        }
        if (other.assignIpv6AddressOnCreation() != null
                && !other.assignIpv6AddressOnCreation().equals(this.assignIpv6AddressOnCreation())) {
            return false;
        }
        if (other.ipv6CidrBlockAssociationSet() == null ^ this.ipv6CidrBlockAssociationSet() == null) {
            return false;
        }
        if (other.ipv6CidrBlockAssociationSet() != null
                && !other.ipv6CidrBlockAssociationSet().equals(this.ipv6CidrBlockAssociationSet())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (availableIpAddressCount() != null) {
            sb.append("AvailableIpAddressCount: ").append(availableIpAddressCount()).append(",");
        }
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (defaultForAz() != null) {
            sb.append("DefaultForAz: ").append(defaultForAz()).append(",");
        }
        if (mapPublicIpOnLaunch() != null) {
            sb.append("MapPublicIpOnLaunch: ").append(mapPublicIpOnLaunch()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (assignIpv6AddressOnCreation() != null) {
            sb.append("AssignIpv6AddressOnCreation: ").append(assignIpv6AddressOnCreation()).append(",");
        }
        if (ipv6CidrBlockAssociationSet() != null) {
            sb.append("Ipv6CidrBlockAssociationSet: ").append(ipv6CidrBlockAssociationSet()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Subnet> {
        /**
         * <p>
         * The Availability Zone of the subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any stopped
         * instances are considered unavailable.
         * </p>
         * 
         * @param availableIpAddressCount
         *        The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any
         *        stopped instances are considered unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableIpAddressCount(Integer availableIpAddressCount);

        /**
         * <p>
         * The IPv4 CIDR block assigned to the subnet.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Indicates whether this is the default subnet for the Availability Zone.
         * </p>
         * 
         * @param defaultForAz
         *        Indicates whether this is the default subnet for the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultForAz(Boolean defaultForAz);

        /**
         * <p>
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         * </p>
         * 
         * @param mapPublicIpOnLaunch
         *        Indicates whether instances launched in this subnet receive a public IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch);

        /**
         * <p>
         * The current state of the subnet.
         * </p>
         * 
         * @param state
         *        The current state of the subnet.
         * @see SubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the subnet.
         * </p>
         * 
         * @param state
         *        The current state of the subnet.
         * @see SubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetState
         */
        Builder state(SubnetState state);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the VPC the subnet is in.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC the subnet is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Indicates whether a network interface created in this subnet (including a network interface created by
         * <a>RunInstances</a>) receives an IPv6 address.
         * </p>
         * 
         * @param assignIpv6AddressOnCreation
         *        Indicates whether a network interface created in this subnet (including a network interface created by
         *        <a>RunInstances</a>) receives an IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Any tags assigned to the subnet.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the subnet.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Integer availableIpAddressCount;

        private String cidrBlock;

        private Boolean defaultForAz;

        private Boolean mapPublicIpOnLaunch;

        private String state;

        private String subnetId;

        private String vpcId;

        private Boolean assignIpv6AddressOnCreation;

        private List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            setAvailabilityZone(model.availabilityZone);
            setAvailableIpAddressCount(model.availableIpAddressCount);
            setCidrBlock(model.cidrBlock);
            setDefaultForAz(model.defaultForAz);
            setMapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            setState(model.state);
            setSubnetId(model.subnetId);
            setVpcId(model.vpcId);
            setAssignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            setIpv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            setTags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getAvailableIpAddressCount() {
            return availableIpAddressCount;
        }

        @Override
        public final Builder availableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public final void setAvailableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getDefaultForAz() {
            return defaultForAz;
        }

        @Override
        public final Builder defaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
            return this;
        }

        public final void setDefaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SubnetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        public final Collection<SubnetIpv6CidrBlockAssociation> getIpv6CidrBlockAssociationSet() {
            return ipv6CidrBlockAssociationSet;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public Subnet build() {
            return new Subnet(this);
        }
    }
}
