/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether monitoring is enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotFleetMonitoring implements ToCopyableBuilder<SpotFleetMonitoring.Builder, SpotFleetMonitoring> {
    private final Boolean enabled;

    private SpotFleetMonitoring(BuilderImpl builder) {
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * Enables monitoring for the instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Enables monitoring for the instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetMonitoring)) {
            return false;
        }
        SpotFleetMonitoring other = (SpotFleetMonitoring) obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SpotFleetMonitoring> {
        /**
         * <p>
         * Enables monitoring for the instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param enabled
         *        Enables monitoring for the instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetMonitoring model) {
            setEnabled(model.enabled);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public SpotFleetMonitoring build() {
            return new SpotFleetMonitoring(this);
        }
    }
}
