/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SecurityGroup implements ToCopyableBuilder<SecurityGroup.Builder, SecurityGroup> {
    private final String description;

    private final String groupName;

    private final List<IpPermission> ipPermissions;

    private final String ownerId;

    private final String groupId;

    private final List<IpPermission> ipPermissionsEgress;

    private final List<Tag> tags;

    private final String vpcId;

    private SecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.ownerId = builder.ownerId;
        this.groupId = builder.groupId;
        this.ipPermissionsEgress = builder.ipPermissionsEgress;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * A description of the security group.
     * </p>
     * 
     * @return A description of the security group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * One or more inbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more inbound rules associated with the security group.
     */
    public List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the security group.
     * </p>
     * 
     * @return The AWS account ID of the owner of the security group.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * [EC2-VPC] One or more outbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC] One or more outbound rules associated with the security group.
     */
    public List<IpPermission> ipPermissionsEgress() {
        return ipPermissionsEgress;
    }

    /**
     * <p>
     * Any tags assigned to the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the security group.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the VPC for the security group.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the VPC for the security group.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((ipPermissions() == null) ? 0 : ipPermissions().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((groupId() == null) ? 0 : groupId().hashCode());
        hashCode = 31 * hashCode + ((ipPermissionsEgress() == null) ? 0 : ipPermissionsEgress().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.ipPermissions() == null ^ this.ipPermissions() == null) {
            return false;
        }
        if (other.ipPermissions() != null && !other.ipPermissions().equals(this.ipPermissions())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.ipPermissionsEgress() == null ^ this.ipPermissionsEgress() == null) {
            return false;
        }
        if (other.ipPermissionsEgress() != null && !other.ipPermissionsEgress().equals(this.ipPermissionsEgress())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (ipPermissions() != null) {
            sb.append("IpPermissions: ").append(ipPermissions()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (ipPermissionsEgress() != null) {
            sb.append("IpPermissionsEgress: ").append(ipPermissionsEgress()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SecurityGroup> {
        /**
         * <p>
         * A description of the security group.
         * </p>
         * 
         * @param description
         *        A description of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * One or more inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        One or more inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * One or more inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        One or more inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The AWS account ID of the owner of the security group.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the owner of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * [EC2-VPC] One or more outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        [EC2-VPC] One or more outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress);

        /**
         * <p>
         * [EC2-VPC] One or more outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        [EC2-VPC] One or more outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(IpPermission... ipPermissionsEgress);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * [EC2-VPC] The ID of the VPC for the security group.
         * </p>
         * 
         * @param vpcId
         *        [EC2-VPC] The ID of the VPC for the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private String groupName;

        private List<IpPermission> ipPermissions;

        private String ownerId;

        private String groupId;

        private List<IpPermission> ipPermissionsEgress;

        private List<Tag> tags;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroup model) {
            setDescription(model.description);
            setGroupName(model.groupName);
            setIpPermissions(model.ipPermissions);
            setOwnerId(model.ownerId);
            setGroupId(model.groupId);
            setIpPermissionsEgress(model.ipPermissionsEgress);
            setTags(model.tags);
            setVpcId(model.vpcId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<IpPermission> getIpPermissions() {
            return ipPermissions;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpPermission> getIpPermissionsEgress() {
            return ipPermissionsEgress;
        }

        @Override
        public final Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copy(ipPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(IpPermission... ipPermissionsEgress) {
            ipPermissionsEgress(Arrays.asList(ipPermissionsEgress));
            return this;
        }

        public final void setIpPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copy(ipPermissionsEgress);
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public SecurityGroup build() {
            return new SecurityGroup(this);
        }
    }
}
