/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ResetImageAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResetImageAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ResetImageAttributeRequest.Builder, ResetImageAttributeRequest> {
    private final String attribute;

    private final String imageId;

    private ResetImageAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.imageId = builder.imageId;
    }

    /**
     * <p>
     * The attribute to reset (currently you can only reset the launch permission attribute).
     * </p>
     * 
     * @return The attribute to reset (currently you can only reset the launch permission attribute).
     * @see ResetImageAttributeName
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetImageAttributeRequest)) {
            return false;
        }
        ResetImageAttributeRequest other = (ResetImageAttributeRequest) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ResetImageAttributeRequest> {
        /**
         * <p>
         * The attribute to reset (currently you can only reset the launch permission attribute).
         * </p>
         * 
         * @param attribute
         *        The attribute to reset (currently you can only reset the launch permission attribute).
         * @see ResetImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResetImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute to reset (currently you can only reset the launch permission attribute).
         * </p>
         * 
         * @param attribute
         *        The attribute to reset (currently you can only reset the launch permission attribute).
         * @see ResetImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResetImageAttributeName
         */
        Builder attribute(ResetImageAttributeName attribute);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);
    }

    private static final class BuilderImpl implements Builder {
        private String attribute;

        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetImageAttributeRequest model) {
            setAttribute(model.attribute);
            setImageId(model.imageId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResetImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public ResetImageAttributeRequest build() {
            return new ResetImageAttributeRequest(this);
        }
    }
}
