/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PurchaseReservedInstancesOffering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseReservedInstancesOfferingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PurchaseReservedInstancesOfferingRequest.Builder, PurchaseReservedInstancesOfferingRequest> {
    private final Integer instanceCount;

    private final String reservedInstancesOfferingId;

    private final ReservedInstanceLimitPrice limitPrice;

    private PurchaseReservedInstancesOfferingRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.limitPrice = builder.limitPrice;
    }

    /**
     * <p>
     * The number of Reserved Instances to purchase.
     * </p>
     * 
     * @return The number of Reserved Instances to purchase.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering to purchase.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering to purchase.
     */
    public String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
     * Instances are not purchased at unexpected prices.
     * </p>
     * 
     * @return Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the
     *         Reserved Instances are not purchased at unexpected prices.
     */
    public ReservedInstanceLimitPrice limitPrice() {
        return limitPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceCount() == null) ? 0 : instanceCount().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesOfferingId() == null) ? 0 : reservedInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + ((limitPrice() == null) ? 0 : limitPrice().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstancesOfferingRequest other = (PurchaseReservedInstancesOfferingRequest) obj;
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.reservedInstancesOfferingId() == null ^ this.reservedInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedInstancesOfferingId() != null
                && !other.reservedInstancesOfferingId().equals(this.reservedInstancesOfferingId())) {
            return false;
        }
        if (other.limitPrice() == null ^ this.limitPrice() == null) {
            return false;
        }
        if (other.limitPrice() != null && !other.limitPrice().equals(this.limitPrice())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (reservedInstancesOfferingId() != null) {
            sb.append("ReservedInstancesOfferingId: ").append(reservedInstancesOfferingId()).append(",");
        }
        if (limitPrice() != null) {
            sb.append("LimitPrice: ").append(limitPrice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
        /**
         * <p>
         * The number of Reserved Instances to purchase.
         * </p>
         * 
         * @param instanceCount
         *        The number of Reserved Instances to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The ID of the Reserved Instance offering to purchase.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
         * Instances are not purchased at unexpected prices.
         * </p>
         * 
         * @param limitPrice
         *        Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the
         *        Reserved Instances are not purchased at unexpected prices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitPrice(ReservedInstanceLimitPrice limitPrice);
    }

    private static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String reservedInstancesOfferingId;

        private ReservedInstanceLimitPrice limitPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstancesOfferingRequest model) {
            setInstanceCount(model.instanceCount);
            setReservedInstancesOfferingId(model.reservedInstancesOfferingId);
            setLimitPrice(model.limitPrice);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final ReservedInstanceLimitPrice getLimitPrice() {
            return limitPrice;
        }

        @Override
        public final Builder limitPrice(ReservedInstanceLimitPrice limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(ReservedInstanceLimitPrice limitPrice) {
            this.limitPrice = limitPrice;
        }

        @Override
        public PurchaseReservedInstancesOfferingRequest build() {
            return new PurchaseReservedInstancesOfferingRequest(this);
        }
    }
}
