/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to purchase Scheduled Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseRequest implements ToCopyableBuilder<PurchaseRequest.Builder, PurchaseRequest> {
    private final Integer instanceCount;

    private final String purchaseToken;

    private PurchaseRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.purchaseToken = builder.purchaseToken;
    }

    /**
     * <p>
     * The number of instances.
     * </p>
     * 
     * @return The number of instances.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The purchase token.
     * </p>
     * 
     * @return The purchase token.
     */
    public String purchaseToken() {
        return purchaseToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceCount() == null) ? 0 : instanceCount().hashCode());
        hashCode = 31 * hashCode + ((purchaseToken() == null) ? 0 : purchaseToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseRequest)) {
            return false;
        }
        PurchaseRequest other = (PurchaseRequest) obj;
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.purchaseToken() == null ^ this.purchaseToken() == null) {
            return false;
        }
        if (other.purchaseToken() != null && !other.purchaseToken().equals(this.purchaseToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (purchaseToken() != null) {
            sb.append("PurchaseToken: ").append(purchaseToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseRequest> {
        /**
         * <p>
         * The number of instances.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The purchase token.
         * </p>
         * 
         * @param purchaseToken
         *        The purchase token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseToken(String purchaseToken);
    }

    private static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String purchaseToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseRequest model) {
            setInstanceCount(model.instanceCount);
            setPurchaseToken(model.purchaseToken);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getPurchaseToken() {
            return purchaseToken;
        }

        @Override
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        @Override
        public PurchaseRequest build() {
            return new PurchaseRequest(this);
        }
    }
}
