/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a placement group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PlacementGroup implements ToCopyableBuilder<PlacementGroup.Builder, PlacementGroup> {
    private final String groupName;

    private final String state;

    private final String strategy;

    private PlacementGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.state = builder.state;
        this.strategy = builder.strategy;
    }

    /**
     * <p>
     * The name of the placement group.
     * </p>
     * 
     * @return The name of the placement group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The state of the placement group.
     * </p>
     * 
     * @return The state of the placement group.
     * @see PlacementGroupState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public String strategy() {
        return strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((strategy() == null) ? 0 : strategy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroup)) {
            return false;
        }
        PlacementGroup other = (PlacementGroup) obj;
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.strategy() == null ^ this.strategy() == null) {
            return false;
        }
        if (other.strategy() != null && !other.strategy().equals(this.strategy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (strategy() != null) {
            sb.append("Strategy: ").append(strategy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PlacementGroup> {
        /**
         * <p>
         * The name of the placement group.
         * </p>
         * 
         * @param groupName
         *        The name of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The state of the placement group.
         * </p>
         * 
         * @param state
         *        The state of the placement group.
         * @see PlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementGroupState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the placement group.
         * </p>
         * 
         * @param state
         *        The state of the placement group.
         * @see PlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementGroupState
         */
        Builder state(PlacementGroupState state);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(PlacementStrategy strategy);
    }

    private static final class BuilderImpl implements Builder {
        private String groupName;

        private String state;

        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroup model) {
            setGroupName(model.groupName);
            setState(model.state);
            setStrategy(model.strategy);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PlacementGroupState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStrategy() {
            return strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public PlacementGroup build() {
            return new PlacementGroup(this);
        }
    }
}
