/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the placement of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Placement implements ToCopyableBuilder<Placement.Builder, Placement> {
    private final String availabilityZone;

    private final String affinity;

    private final String groupName;

    private final String hostId;

    private final String tenancy;

    private final String spreadDomain;

    private Placement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.tenancy = builder.tenancy;
        this.spreadDomain = builder.spreadDomain;
    }

    /**
     * <p>
     * The Availability Zone of the instance.
     * </p>
     * 
     * @return The Availability Zone of the instance.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * 
     * @return The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
     *         <a>ImportInstance</a> command.
     */
    public String affinity() {
        return affinity;
    }

    /**
     * <p>
     * The name of the placement group the instance is in (for cluster compute instances).
     * </p>
     * 
     * @return The name of the placement group the instance is in (for cluster compute instances).
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * 
     * @return The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
     *         <a>ImportInstance</a> command.
     */
    public String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         the <a>ImportInstance</a> command.
     * @see Tenancy
     */
    public String tenancy() {
        return tenancy;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String spreadDomain() {
        return spreadDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((affinity() == null) ? 0 : affinity().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((hostId() == null) ? 0 : hostId().hashCode());
        hashCode = 31 * hashCode + ((tenancy() == null) ? 0 : tenancy().hashCode());
        hashCode = 31 * hashCode + ((spreadDomain() == null) ? 0 : spreadDomain().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.affinity() == null ^ this.affinity() == null) {
            return false;
        }
        if (other.affinity() != null && !other.affinity().equals(this.affinity())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.hostId() == null ^ this.hostId() == null) {
            return false;
        }
        if (other.hostId() != null && !other.hostId().equals(this.hostId())) {
            return false;
        }
        if (other.tenancy() == null ^ this.tenancy() == null) {
            return false;
        }
        if (other.tenancy() != null && !other.tenancy().equals(this.tenancy())) {
            return false;
        }
        if (other.spreadDomain() == null ^ this.spreadDomain() == null) {
            return false;
        }
        if (other.spreadDomain() != null && !other.spreadDomain().equals(this.spreadDomain())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (affinity() != null) {
            sb.append("Affinity: ").append(affinity()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (hostId() != null) {
            sb.append("HostId: ").append(hostId()).append(",");
        }
        if (tenancy() != null) {
            sb.append("Tenancy: ").append(tenancy()).append(",");
        }
        if (spreadDomain() != null) {
            sb.append("SpreadDomain: ").append(spreadDomain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Placement> {
        /**
         * <p>
         * The Availability Zone of the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param affinity
         *        The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
         *        <a>ImportInstance</a> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * The name of the placement group the instance is in (for cluster compute instances).
         * </p>
         * 
         * @param groupName
         *        The name of the placement group the instance is in (for cluster compute instances).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
         *        <a>ImportInstance</a> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for the <a>ImportInstance</a> command.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for the <a>ImportInstance</a> command.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param spreadDomain
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spreadDomain(String spreadDomain);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String affinity;

        private String groupName;

        private String hostId;

        private String tenancy;

        private String spreadDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            setAvailabilityZone(model.availabilityZone);
            setAffinity(model.affinity);
            setGroupName(model.groupName);
            setHostId(model.hostId);
            setTenancy(model.tenancy);
            setSpreadDomain(model.spreadDomain);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAffinity() {
            return affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getHostId() {
            return hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getSpreadDomain() {
            return spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        @Override
        public Placement build() {
            return new Placement(this);
        }
    }
}
