/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcPeeringConnectionOptionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ModifyVpcPeeringConnectionOptionsResponse.Builder, ModifyVpcPeeringConnectionOptionsResponse> {
    private final PeeringConnectionOptions accepterPeeringConnectionOptions;

    private final PeeringConnectionOptions requesterPeeringConnectionOptions;

    private ModifyVpcPeeringConnectionOptionsResponse(BuilderImpl builder) {
        this.accepterPeeringConnectionOptions = builder.accepterPeeringConnectionOptions;
        this.requesterPeeringConnectionOptions = builder.requesterPeeringConnectionOptions;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the accepter VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the accepter VPC.
     */
    public PeeringConnectionOptions accepterPeeringConnectionOptions() {
        return accepterPeeringConnectionOptions;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the requester VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the requester VPC.
     */
    public PeeringConnectionOptions requesterPeeringConnectionOptions() {
        return requesterPeeringConnectionOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((accepterPeeringConnectionOptions() == null) ? 0 : accepterPeeringConnectionOptions().hashCode());
        hashCode = 31 * hashCode
                + ((requesterPeeringConnectionOptions() == null) ? 0 : requesterPeeringConnectionOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcPeeringConnectionOptionsResponse)) {
            return false;
        }
        ModifyVpcPeeringConnectionOptionsResponse other = (ModifyVpcPeeringConnectionOptionsResponse) obj;
        if (other.accepterPeeringConnectionOptions() == null ^ this.accepterPeeringConnectionOptions() == null) {
            return false;
        }
        if (other.accepterPeeringConnectionOptions() != null
                && !other.accepterPeeringConnectionOptions().equals(this.accepterPeeringConnectionOptions())) {
            return false;
        }
        if (other.requesterPeeringConnectionOptions() == null ^ this.requesterPeeringConnectionOptions() == null) {
            return false;
        }
        if (other.requesterPeeringConnectionOptions() != null
                && !other.requesterPeeringConnectionOptions().equals(this.requesterPeeringConnectionOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accepterPeeringConnectionOptions() != null) {
            sb.append("AccepterPeeringConnectionOptions: ").append(accepterPeeringConnectionOptions()).append(",");
        }
        if (requesterPeeringConnectionOptions() != null) {
            sb.append("RequesterPeeringConnectionOptions: ").append(requesterPeeringConnectionOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsResponse> {
        /**
         * <p>
         * Information about the VPC peering connection options for the accepter VPC.
         * </p>
         * 
         * @param accepterPeeringConnectionOptions
         *        Information about the VPC peering connection options for the accepter VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterPeeringConnectionOptions(PeeringConnectionOptions accepterPeeringConnectionOptions);

        /**
         * <p>
         * Information about the VPC peering connection options for the requester VPC.
         * </p>
         * 
         * @param requesterPeeringConnectionOptions
         *        Information about the VPC peering connection options for the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPeeringConnectionOptions(PeeringConnectionOptions requesterPeeringConnectionOptions);
    }

    private static final class BuilderImpl implements Builder {
        private PeeringConnectionOptions accepterPeeringConnectionOptions;

        private PeeringConnectionOptions requesterPeeringConnectionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcPeeringConnectionOptionsResponse model) {
            setAccepterPeeringConnectionOptions(model.accepterPeeringConnectionOptions);
            setRequesterPeeringConnectionOptions(model.requesterPeeringConnectionOptions);
        }

        public final PeeringConnectionOptions getAccepterPeeringConnectionOptions() {
            return accepterPeeringConnectionOptions;
        }

        @Override
        public final Builder accepterPeeringConnectionOptions(PeeringConnectionOptions accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
            return this;
        }

        public final void setAccepterPeeringConnectionOptions(PeeringConnectionOptions accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
        }

        public final PeeringConnectionOptions getRequesterPeeringConnectionOptions() {
            return requesterPeeringConnectionOptions;
        }

        @Override
        public final Builder requesterPeeringConnectionOptions(PeeringConnectionOptions requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
            return this;
        }

        public final void setRequesterPeeringConnectionOptions(PeeringConnectionOptions requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
        }

        @Override
        public ModifyVpcPeeringConnectionOptionsResponse build() {
            return new ModifyVpcPeeringConnectionOptionsResponse(this);
        }
    }
}
