/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcPeeringConnectionOptionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyVpcPeeringConnectionOptionsRequest.Builder, ModifyVpcPeeringConnectionOptionsRequest> {
    private final PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;

    private final PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;

    private final String vpcPeeringConnectionId;

    private ModifyVpcPeeringConnectionOptionsRequest(BuilderImpl builder) {
        this.accepterPeeringConnectionOptions = builder.accepterPeeringConnectionOptions;
        this.requesterPeeringConnectionOptions = builder.requesterPeeringConnectionOptions;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The VPC peering connection options for the accepter VPC.
     * </p>
     * 
     * @return The VPC peering connection options for the accepter VPC.
     */
    public PeeringConnectionOptionsRequest accepterPeeringConnectionOptions() {
        return accepterPeeringConnectionOptions;
    }

    /**
     * <p>
     * The VPC peering connection options for the requester VPC.
     * </p>
     * 
     * @return The VPC peering connection options for the requester VPC.
     */
    public PeeringConnectionOptionsRequest requesterPeeringConnectionOptions() {
        return requesterPeeringConnectionOptions;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((accepterPeeringConnectionOptions() == null) ? 0 : accepterPeeringConnectionOptions().hashCode());
        hashCode = 31 * hashCode
                + ((requesterPeeringConnectionOptions() == null) ? 0 : requesterPeeringConnectionOptions().hashCode());
        hashCode = 31 * hashCode + ((vpcPeeringConnectionId() == null) ? 0 : vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcPeeringConnectionOptionsRequest)) {
            return false;
        }
        ModifyVpcPeeringConnectionOptionsRequest other = (ModifyVpcPeeringConnectionOptionsRequest) obj;
        if (other.accepterPeeringConnectionOptions() == null ^ this.accepterPeeringConnectionOptions() == null) {
            return false;
        }
        if (other.accepterPeeringConnectionOptions() != null
                && !other.accepterPeeringConnectionOptions().equals(this.accepterPeeringConnectionOptions())) {
            return false;
        }
        if (other.requesterPeeringConnectionOptions() == null ^ this.requesterPeeringConnectionOptions() == null) {
            return false;
        }
        if (other.requesterPeeringConnectionOptions() != null
                && !other.requesterPeeringConnectionOptions().equals(this.requesterPeeringConnectionOptions())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionId() != null && !other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accepterPeeringConnectionOptions() != null) {
            sb.append("AccepterPeeringConnectionOptions: ").append(accepterPeeringConnectionOptions()).append(",");
        }
        if (requesterPeeringConnectionOptions() != null) {
            sb.append("RequesterPeeringConnectionOptions: ").append(requesterPeeringConnectionOptions()).append(",");
        }
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsRequest> {
        /**
         * <p>
         * The VPC peering connection options for the accepter VPC.
         * </p>
         * 
         * @param accepterPeeringConnectionOptions
         *        The VPC peering connection options for the accepter VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions);

        /**
         * <p>
         * The VPC peering connection options for the requester VPC.
         * </p>
         * 
         * @param requesterPeeringConnectionOptions
         *        The VPC peering connection options for the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions);

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    private static final class BuilderImpl implements Builder {
        private PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;

        private PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcPeeringConnectionOptionsRequest model) {
            setAccepterPeeringConnectionOptions(model.accepterPeeringConnectionOptions);
            setRequesterPeeringConnectionOptions(model.requesterPeeringConnectionOptions);
            setVpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final PeeringConnectionOptionsRequest getAccepterPeeringConnectionOptions() {
            return accepterPeeringConnectionOptions;
        }

        @Override
        public final Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
            return this;
        }

        public final void setAccepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
        }

        public final PeeringConnectionOptionsRequest getRequesterPeeringConnectionOptions() {
            return requesterPeeringConnectionOptions;
        }

        @Override
        public final Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
            return this;
        }

        public final void setRequesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public ModifyVpcPeeringConnectionOptionsRequest build() {
            return new ModifyVpcPeeringConnectionOptionsRequest(this);
        }
    }
}
