/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifySnapshotAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifySnapshotAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifySnapshotAttributeRequest.Builder, ModifySnapshotAttributeRequest> {
    private final String attribute;

    private final CreateVolumePermissionModifications createVolumePermission;

    private final List<String> groupNames;

    private final String operationType;

    private final String snapshotId;

    private final List<String> userIds;

    private ModifySnapshotAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.createVolumePermission = builder.createVolumePermission;
        this.groupNames = builder.groupNames;
        this.operationType = builder.operationType;
        this.snapshotId = builder.snapshotId;
        this.userIds = builder.userIds;
    }

    /**
     * <p>
     * The snapshot attribute to modify.
     * </p>
     * <note>
     * <p>
     * Only volume creation permissions may be modified at the customer level.
     * </p>
     * </note>
     * 
     * @return The snapshot attribute to modify.</p> <note>
     *         <p>
     *         Only volume creation permissions may be modified at the customer level.
     *         </p>
     * @see SnapshotAttributeName
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * A JSON representation of the snapshot attribute modification.
     * </p>
     * 
     * @return A JSON representation of the snapshot attribute modification.
     */
    public CreateVolumePermissionModifications createVolumePermission() {
        return createVolumePermission;
    }

    /**
     * <p>
     * The group to modify for the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The group to modify for the snapshot.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    /**
     * <p>
     * The type of operation to perform to the attribute.
     * </p>
     * 
     * @return The type of operation to perform to the attribute.
     * @see OperationType
     */
    public String operationType() {
        return operationType;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The account ID to modify for the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The account ID to modify for the snapshot.
     */
    public List<String> userIds() {
        return userIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((createVolumePermission() == null) ? 0 : createVolumePermission().hashCode());
        hashCode = 31 * hashCode + ((groupNames() == null) ? 0 : groupNames().hashCode());
        hashCode = 31 * hashCode + ((operationType() == null) ? 0 : operationType().hashCode());
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        hashCode = 31 * hashCode + ((userIds() == null) ? 0 : userIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotAttributeRequest)) {
            return false;
        }
        ModifySnapshotAttributeRequest other = (ModifySnapshotAttributeRequest) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.createVolumePermission() == null ^ this.createVolumePermission() == null) {
            return false;
        }
        if (other.createVolumePermission() != null && !other.createVolumePermission().equals(this.createVolumePermission())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        if (other.groupNames() != null && !other.groupNames().equals(this.groupNames())) {
            return false;
        }
        if (other.operationType() == null ^ this.operationType() == null) {
            return false;
        }
        if (other.operationType() != null && !other.operationType().equals(this.operationType())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.userIds() == null ^ this.userIds() == null) {
            return false;
        }
        if (other.userIds() != null && !other.userIds().equals(this.userIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (createVolumePermission() != null) {
            sb.append("CreateVolumePermission: ").append(createVolumePermission()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        if (operationType() != null) {
            sb.append("OperationType: ").append(operationType()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        if (userIds() != null) {
            sb.append("UserIds: ").append(userIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
        /**
         * <p>
         * The snapshot attribute to modify.
         * </p>
         * <note>
         * <p>
         * Only volume creation permissions may be modified at the customer level.
         * </p>
         * </note>
         * 
         * @param attribute
         *        The snapshot attribute to modify.</p> <note>
         *        <p>
         *        Only volume creation permissions may be modified at the customer level.
         *        </p>
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The snapshot attribute to modify.
         * </p>
         * <note>
         * <p>
         * Only volume creation permissions may be modified at the customer level.
         * </p>
         * </note>
         * 
         * @param attribute
         *        The snapshot attribute to modify.</p> <note>
         *        <p>
         *        Only volume creation permissions may be modified at the customer level.
         *        </p>
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(SnapshotAttributeName attribute);

        /**
         * <p>
         * A JSON representation of the snapshot attribute modification.
         * </p>
         * 
         * @param createVolumePermission
         *        A JSON representation of the snapshot attribute modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermission(CreateVolumePermissionModifications createVolumePermission);

        /**
         * <p>
         * The group to modify for the snapshot.
         * </p>
         * 
         * @param groupNames
         *        The group to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * The group to modify for the snapshot.
         * </p>
         * 
         * @param groupNames
         *        The group to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);

        /**
         * <p>
         * The type of operation to perform to the attribute.
         * </p>
         * 
         * @param operationType
         *        The type of operation to perform to the attribute.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of operation to perform to the attribute.
         * </p>
         * 
         * @param operationType
         *        The type of operation to perform to the attribute.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The account ID to modify for the snapshot.
         * </p>
         * 
         * @param userIds
         *        The account ID to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The account ID to modify for the snapshot.
         * </p>
         * 
         * @param userIds
         *        The account ID to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);
    }

    private static final class BuilderImpl implements Builder {
        private String attribute;

        private CreateVolumePermissionModifications createVolumePermission;

        private List<String> groupNames;

        private String operationType;

        private String snapshotId;

        private List<String> userIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotAttributeRequest model) {
            setAttribute(model.attribute);
            setCreateVolumePermission(model.createVolumePermission);
            setGroupNames(model.groupNames);
            setOperationType(model.operationType);
            setSnapshotId(model.snapshotId);
            setUserIds(model.userIds);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final CreateVolumePermissionModifications getCreateVolumePermission() {
            return createVolumePermission;
        }

        @Override
        public final Builder createVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
            this.createVolumePermission = createVolumePermission;
            return this;
        }

        public final void setCreateVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
            this.createVolumePermission = createVolumePermission;
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        public final String getOperationType() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Collection<String> getUserIds() {
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        @Override
        public ModifySnapshotAttributeRequest build() {
            return new ModifySnapshotAttributeRequest(this);
        }
    }
}
