/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyInstancePlacement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyInstancePlacementRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyInstancePlacementRequest.Builder, ModifyInstancePlacementRequest> {
    private final String affinity;

    private final String hostId;

    private final String instanceId;

    private final String tenancy;

    private ModifyInstancePlacementRequest(BuilderImpl builder) {
        this.affinity = builder.affinity;
        this.hostId = builder.hostId;
        this.instanceId = builder.instanceId;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * The new affinity setting for the instance.
     * </p>
     * 
     * @return The new affinity setting for the instance.
     * @see Affinity
     */
    public String affinity() {
        return affinity;
    }

    /**
     * <p>
     * The ID of the Dedicated Host that the instance will have affinity with.
     * </p>
     * 
     * @return The ID of the Dedicated Host that the instance will have affinity with.
     */
    public String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The ID of the instance that you are modifying.
     * </p>
     * 
     * @return The ID of the instance that you are modifying.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The tenancy of the instance that you are modifying.
     * </p>
     * 
     * @return The tenancy of the instance that you are modifying.
     * @see HostTenancy
     */
    public String tenancy() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((affinity() == null) ? 0 : affinity().hashCode());
        hashCode = 31 * hashCode + ((hostId() == null) ? 0 : hostId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((tenancy() == null) ? 0 : tenancy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstancePlacementRequest)) {
            return false;
        }
        ModifyInstancePlacementRequest other = (ModifyInstancePlacementRequest) obj;
        if (other.affinity() == null ^ this.affinity() == null) {
            return false;
        }
        if (other.affinity() != null && !other.affinity().equals(this.affinity())) {
            return false;
        }
        if (other.hostId() == null ^ this.hostId() == null) {
            return false;
        }
        if (other.hostId() != null && !other.hostId().equals(this.hostId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.tenancy() == null ^ this.tenancy() == null) {
            return false;
        }
        if (other.tenancy() != null && !other.tenancy().equals(this.tenancy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (affinity() != null) {
            sb.append("Affinity: ").append(affinity()).append(",");
        }
        if (hostId() != null) {
            sb.append("HostId: ").append(hostId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (tenancy() != null) {
            sb.append("Tenancy: ").append(tenancy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyInstancePlacementRequest> {
        /**
         * <p>
         * The new affinity setting for the instance.
         * </p>
         * 
         * @param affinity
         *        The new affinity setting for the instance.
         * @see Affinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Affinity
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * The new affinity setting for the instance.
         * </p>
         * 
         * @param affinity
         *        The new affinity setting for the instance.
         * @see Affinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Affinity
         */
        Builder affinity(Affinity affinity);

        /**
         * <p>
         * The ID of the Dedicated Host that the instance will have affinity with.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host that the instance will have affinity with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The ID of the instance that you are modifying.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that you are modifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The tenancy of the instance that you are modifying.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance that you are modifying.
         * @see HostTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance that you are modifying.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance that you are modifying.
         * @see HostTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostTenancy
         */
        Builder tenancy(HostTenancy tenancy);
    }

    private static final class BuilderImpl implements Builder {
        private String affinity;

        private String hostId;

        private String instanceId;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstancePlacementRequest model) {
            setAffinity(model.affinity);
            setHostId(model.hostId);
            setInstanceId(model.instanceId);
            setTenancy(model.tenancy);
        }

        public final String getAffinity() {
            return affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        @Override
        public final Builder affinity(Affinity affinity) {
            this.affinity(affinity.toString());
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getHostId() {
            return hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(HostTenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public ModifyInstancePlacementRequest build() {
            return new ModifyInstancePlacementRequest(this);
        }
    }
}
