/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
final class Ipv6CidrBlockSetCopier {
    static List<Ipv6CidrBlock> copy(Collection<Ipv6CidrBlock> ipv6CidrBlockSetParam) {
        if (ipv6CidrBlockSetParam == null) {
            return null;
        }
        List<Ipv6CidrBlock> ipv6CidrBlockSetParamCopy = new ArrayList<>(ipv6CidrBlockSetParam.size());
        for (Ipv6CidrBlock e : ipv6CidrBlockSetParam) {
            ipv6CidrBlockSetParamCopy.add(e);
        }
        return Collections.unmodifiableList(ipv6CidrBlockSetParamCopy);
    }
}
