/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IpPermission implements ToCopyableBuilder<IpPermission.Builder, IpPermission> {
    private final Integer fromPort;

    private final String ipProtocol;

    private final List<Ipv6Range> ipv6Ranges;

    private final List<PrefixListId> prefixListIds;

    private final Integer toPort;

    private final List<UserIdGroupPair> userIdGroupPairs;

    private final List<IpRange> ipv4Ranges;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
        this.ipv4Ranges = builder.ipv4Ranges;
    }

    /**
     * <p>
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code>
     * indicates all ICMP/ICMPv6 types.
     * </p>
     * 
     * @return The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
     *         <code>-1</code> indicates all ICMP/ICMPv6 types.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     * </p>
     * <p>
     * [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying
     * <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or
     * <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port range you specify. For
     * <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For <code>58</code>
     * (ICMPv6), you can optionally specify a port range; if you don't, traffic for all types and codes is allowed when
     * authorizing rules.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     *         href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     *         </p>
     *         <p>
     *         [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
     *         specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
     *         <code>icmp</code>, or <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port range
     *         you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port
     *         range. For <code>58</code> (ICMPv6), you can optionally specify a port range; if you don't, traffic for
     *         all types and codes is allowed when authorizing rules.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * [EC2-VPC only] One or more IPv6 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC only] One or more IPv6 ranges.
     */
    public List<Ipv6Range> ipv6Ranges() {
        return ipv6Ranges;
    }

    /**
     * <p>
     * (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
     * <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
     * <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a VPC
     * endpoint from instances associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
     *         <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
     *         <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a
     *         VPC endpoint from instances associated with the security group.
     */
    public List<PrefixListId> prefixListIds() {
        return prefixListIds;
    }

    /**
     * <p>
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates
     * all ICMP/ICMPv6 codes for the specified ICMP type.
     * </p>
     * 
     * @return The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
     *         indicates all ICMP/ICMPv6 codes for the specified ICMP type.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * One or more security group and AWS account ID pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group and AWS account ID pairs.
     */
    public List<UserIdGroupPair> userIdGroupPairs() {
        return userIdGroupPairs;
    }

    /**
     * <p>
     * One or more IPv4 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more IPv4 ranges.
     */
    public List<IpRange> ipv4Ranges() {
        return ipv4Ranges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fromPort() == null) ? 0 : fromPort().hashCode());
        hashCode = 31 * hashCode + ((ipProtocol() == null) ? 0 : ipProtocol().hashCode());
        hashCode = 31 * hashCode + ((ipv6Ranges() == null) ? 0 : ipv6Ranges().hashCode());
        hashCode = 31 * hashCode + ((prefixListIds() == null) ? 0 : prefixListIds().hashCode());
        hashCode = 31 * hashCode + ((toPort() == null) ? 0 : toPort().hashCode());
        hashCode = 31 * hashCode + ((userIdGroupPairs() == null) ? 0 : userIdGroupPairs().hashCode());
        hashCode = 31 * hashCode + ((ipv4Ranges() == null) ? 0 : ipv4Ranges().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission) obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.ipProtocol() == null ^ this.ipProtocol() == null) {
            return false;
        }
        if (other.ipProtocol() != null && !other.ipProtocol().equals(this.ipProtocol())) {
            return false;
        }
        if (other.ipv6Ranges() == null ^ this.ipv6Ranges() == null) {
            return false;
        }
        if (other.ipv6Ranges() != null && !other.ipv6Ranges().equals(this.ipv6Ranges())) {
            return false;
        }
        if (other.prefixListIds() == null ^ this.prefixListIds() == null) {
            return false;
        }
        if (other.prefixListIds() != null && !other.prefixListIds().equals(this.prefixListIds())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.userIdGroupPairs() == null ^ this.userIdGroupPairs() == null) {
            return false;
        }
        if (other.userIdGroupPairs() != null && !other.userIdGroupPairs().equals(this.userIdGroupPairs())) {
            return false;
        }
        if (other.ipv4Ranges() == null ^ this.ipv4Ranges() == null) {
            return false;
        }
        if (other.ipv4Ranges() != null && !other.ipv4Ranges().equals(this.ipv4Ranges())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (ipProtocol() != null) {
            sb.append("IpProtocol: ").append(ipProtocol()).append(",");
        }
        if (ipv6Ranges() != null) {
            sb.append("Ipv6Ranges: ").append(ipv6Ranges()).append(",");
        }
        if (prefixListIds() != null) {
            sb.append("PrefixListIds: ").append(prefixListIds()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (userIdGroupPairs() != null) {
            sb.append("UserIdGroupPairs: ").append(userIdGroupPairs()).append(",");
        }
        if (ipv4Ranges() != null) {
            sb.append("Ipv4Ranges: ").append(ipv4Ranges()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IpPermission> {
        /**
         * <p>
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         * <code>-1</code> indicates all ICMP/ICMPv6 types.
         * </p>
         * 
         * @param fromPort
         *        The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         * </p>
         * <p>
         * [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
         * specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
         * <code>icmp</code>, or <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port range you
         * specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For
         * <code>58</code> (ICMPv6), you can optionally specify a port range; if you don't, traffic for all types and
         * codes is allowed when authorizing rules.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         *        href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         *        </p>
         *        <p>
         *        [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
         *        specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
         *        <code>icmp</code>, or <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port
         *        range you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a
         *        port range. For <code>58</code> (ICMPv6), you can optionally specify a port range; if you don't,
         *        traffic for all types and codes is allowed when authorizing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * [EC2-VPC only] One or more IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        [EC2-VPC only] One or more IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges);

        /**
         * <p>
         * [EC2-VPC only] One or more IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        [EC2-VPC only] One or more IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(Ipv6Range... ipv6Ranges);

        /**
         * <p>
         * (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         * <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         * <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a VPC
         * endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         *        <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         *        <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a
         *        VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<PrefixListId> prefixListIds);

        /**
         * <p>
         * (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         * <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         * <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a VPC
         * endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         *        <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         *        <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a
         *        VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(PrefixListId... prefixListIds);

        /**
         * <p>
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
         * indicates all ICMP/ICMPv6 codes for the specified ICMP type.
         * </p>
         * 
         * @param toPort
         *        The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 codes for the specified ICMP type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * One or more security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        One or more security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs);

        /**
         * <p>
         * One or more security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        One or more security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs);

        /**
         * <p>
         * One or more IPv4 ranges.
         * </p>
         * 
         * @param ipv4Ranges
         *        One or more IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Ranges(Collection<IpRange> ipv4Ranges);

        /**
         * <p>
         * One or more IPv4 ranges.
         * </p>
         * 
         * @param ipv4Ranges
         *        One or more IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Ranges(IpRange... ipv4Ranges);
    }

    private static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private String ipProtocol;

        private List<Ipv6Range> ipv6Ranges;

        private List<PrefixListId> prefixListIds;

        private Integer toPort;

        private List<UserIdGroupPair> userIdGroupPairs;

        private List<IpRange> ipv4Ranges;

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            setFromPort(model.fromPort);
            setIpProtocol(model.ipProtocol);
            setIpv6Ranges(model.ipv6Ranges);
            setPrefixListIds(model.prefixListIds);
            setToPort(model.toPort);
            setUserIdGroupPairs(model.userIdGroupPairs);
            setIpv4Ranges(model.ipv4Ranges);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<Ipv6Range> getIpv6Ranges() {
            return ipv6Ranges;
        }

        @Override
        public final Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Ipv6Range... ipv6Ranges) {
            ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        public final void setIpv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
        }

        public final Collection<PrefixListId> getPrefixListIds() {
            return prefixListIds;
        }

        @Override
        public final Builder prefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(PrefixListId... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final void setPrefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair> getUserIdGroupPairs() {
            return userIdGroupPairs;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs) {
            userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
        }

        public final Collection<IpRange> getIpv4Ranges() {
            return ipv4Ranges;
        }

        @Override
        public final Builder ipv4Ranges(Collection<IpRange> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copy(ipv4Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Ranges(IpRange... ipv4Ranges) {
            ipv4Ranges(Arrays.asList(ipv4Ranges));
            return this;
        }

        public final void setIpv4Ranges(Collection<IpRange> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copy(ipv4Ranges);
        }

        @Override
        public IpPermission build() {
            return new IpPermission(this);
        }
    }
}
