/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceNetworkInterfaceSpecification implements
        ToCopyableBuilder<InstanceNetworkInterfaceSpecification.Builder, InstanceNetworkInterfaceSpecification> {
    private final Boolean associatePublicIpAddress;

    private final Boolean deleteOnTermination;

    private final String description;

    private final Integer deviceIndex;

    private final List<String> groups;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final List<PrivateIpAddressSpecification> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final String subnetId;

    private InstanceNetworkInterfaceSpecification(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can
     * only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an
     * existing one. You cannot specify more than one network interface in the request. If launching into a default
     * subnet, the default value is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP
     *         address can only be assigned to a network interface for eth0, and can only be assigned to a new network
     *         interface, not an existing one. You cannot specify more than one network interface in the request. If
     *         launching into a default subnet, the default value is <code>true</code>.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
     * <code>true</code> only if creating a new network interface when launching an instance.
     * </p>
     * 
     * @return If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
     *         <code>true</code> only if creating a new network interface when launching an instance.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The description of the network interface. Applies only if creating a network interface when launching an
     * instance.
     * </p>
     * 
     * @return The description of the network interface. Applies only if creating a network interface when launching an
     *         instance.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The index of the device on the instance for the network interface attachment. If you are specifying a network
     * interface in a <a>RunInstances</a> request, you must provide the device index.
     * </p>
     * 
     * @return The index of the device on the instance for the network interface attachment. If you are specifying a
     *         network interface in a <a>RunInstances</a> request, you must provide the device index.
     */
    public Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * The IDs of the security groups for the network interface. Applies only if creating a network interface when
     * launching an instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the security groups for the network interface. Applies only if creating a network interface
     *         when launching an instance.
     */
    public List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the
     * range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same
     * request. You can specify this option if you've specified a minimum number of instances to launch.
     * </p>
     * 
     * @return A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from
     *         the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses
     *         in the same request. You can specify this option if you've specified a minimum number of instances to
     *         launch.
     */
    public Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * <p>
     * One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option to
     * assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a
     * minimum number of instances to launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the
     *         option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've
     *         specified a minimum number of instances to launch.
     */
    public List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The private IPv4 address of the network interface. Applies only if creating a network interface when launching an
     * instance. You cannot specify this option if you're launching more than one instance in a <a>RunInstances</a>
     * request.
     * </p>
     * 
     * @return The private IPv4 address of the network interface. Applies only if creating a network interface when
     *         launching an instance. You cannot specify this option if you're launching more than one instance in a
     *         <a>RunInstances</a> request.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be
     * designated as primary. You cannot specify this option if you're launching more than one instance in a
     * <a>RunInstances</a> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can
     *         be designated as primary. You cannot specify this option if you're launching more than one instance in a
     *         <a>RunInstances</a> request.
     */
    public List<PrivateIpAddressSpecification> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private
     * IP address using the private IP addresses option. You cannot specify this option if you're launching more than
     * one instance in a <a>RunInstances</a> request.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses. You can't specify this option and specify more than one
     *         private IP address using the private IP addresses option. You cannot specify this option if you're
     *         launching more than one instance in a <a>RunInstances</a> request.
     */
    public Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the subnet associated with the network string. Applies only if creating a network interface when
     * launching an instance.
     * </p>
     * 
     * @return The ID of the subnet associated with the network string. Applies only if creating a network interface
     *         when launching an instance.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associatePublicIpAddress() == null) ? 0 : associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + ((deleteOnTermination() == null) ? 0 : deleteOnTermination().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((deviceIndex() == null) ? 0 : deviceIndex().hashCode());
        hashCode = 31 * hashCode + ((groups() == null) ? 0 : groups().hashCode());
        hashCode = 31 * hashCode + ((ipv6AddressCount() == null) ? 0 : ipv6AddressCount().hashCode());
        hashCode = 31 * hashCode + ((ipv6Addresses() == null) ? 0 : ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddresses() == null) ? 0 : privateIpAddresses().hashCode());
        hashCode = 31 * hashCode + ((secondaryPrivateIpAddressCount() == null) ? 0 : secondaryPrivateIpAddressCount().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceSpecification)) {
            return false;
        }
        InstanceNetworkInterfaceSpecification other = (InstanceNetworkInterfaceSpecification) obj;
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deviceIndex() == null ^ this.deviceIndex() == null) {
            return false;
        }
        if (other.deviceIndex() != null && !other.deviceIndex().equals(this.deviceIndex())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.ipv6AddressCount() == null ^ this.ipv6AddressCount() == null) {
            return false;
        }
        if (other.ipv6AddressCount() != null && !other.ipv6AddressCount().equals(this.ipv6AddressCount())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        if (other.privateIpAddresses() != null && !other.privateIpAddresses().equals(this.privateIpAddresses())) {
            return false;
        }
        if (other.secondaryPrivateIpAddressCount() == null ^ this.secondaryPrivateIpAddressCount() == null) {
            return false;
        }
        if (other.secondaryPrivateIpAddressCount() != null
                && !other.secondaryPrivateIpAddressCount().equals(this.secondaryPrivateIpAddressCount())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(associatePublicIpAddress()).append(",");
        }
        if (deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(deleteOnTermination()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(deviceIndex()).append(",");
        }
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (ipv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: ").append(ipv6AddressCount()).append(",");
        }
        if (ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(ipv6Addresses()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(privateIpAddresses()).append(",");
        }
        if (secondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: ").append(secondaryPrivateIpAddressCount()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceNetworkInterfaceSpecification> {
        /**
         * <p>
         * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address
         * can only be assigned to a network interface for eth0, and can only be assigned to a new network interface,
         * not an existing one. You cannot specify more than one network interface in the request. If launching into a
         * default subnet, the default value is <code>true</code>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP
         *        address can only be assigned to a network interface for eth0, and can only be assigned to a new
         *        network interface, not an existing one. You cannot specify more than one network interface in the
         *        request. If launching into a default subnet, the default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
         * <code>true</code> only if creating a new network interface when launching an instance.
         * </p>
         * 
         * @param deleteOnTermination
         *        If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
         *        <code>true</code> only if creating a new network interface when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The description of the network interface. Applies only if creating a network interface when launching an
         * instance.
         * </p>
         * 
         * @param description
         *        The description of the network interface. Applies only if creating a network interface when launching
         *        an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The index of the device on the instance for the network interface attachment. If you are specifying a network
         * interface in a <a>RunInstances</a> request, you must provide the device index.
         * </p>
         * 
         * @param deviceIndex
         *        The index of the device on the instance for the network interface attachment. If you are specifying a
         *        network interface in a <a>RunInstances</a> request, you must provide the device index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The IDs of the security groups for the network interface. Applies only if creating a network interface when
         * launching an instance.
         * </p>
         * 
         * @param groups
         *        The IDs of the security groups for the network interface. Applies only if creating a network interface
         *        when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of the security groups for the network interface. Applies only if creating a network interface when
         * launching an instance.
         * </p>
         * 
         * @param groups
         *        The IDs of the security groups for the network interface. Applies only if creating a network interface
         *        when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the
         * range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the
         * same request. You can specify this option if you've specified a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6AddressCount
         *        A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses
         *        from the range of the subnet. You cannot specify this option and the option to assign specific IPv6
         *        addresses in the same request. You can specify this option if you've specified a minimum number of
         *        instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option
         * to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified
         * a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the
         *        option to assign a number of IPv6 addresses in the same request. You cannot specify this option if
         *        you've specified a minimum number of instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option
         * to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified
         * a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the
         *        option to assign a number of IPv6 addresses in the same request. You cannot specify this option if
         *        you've specified a minimum number of instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The private IPv4 address of the network interface. Applies only if creating a network interface when
         * launching an instance. You cannot specify this option if you're launching more than one instance in a
         * <a>RunInstances</a> request.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address of the network interface. Applies only if creating a network interface when
         *        launching an instance. You cannot specify this option if you're launching more than one instance in a
         *        <a>RunInstances</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be
         * designated as primary. You cannot specify this option if you're launching more than one instance in a
         * <a>RunInstances</a> request.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address
         *        can be designated as primary. You cannot specify this option if you're launching more than one
         *        instance in a <a>RunInstances</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be
         * designated as primary. You cannot specify this option if you're launching more than one instance in a
         * <a>RunInstances</a> request.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address
         *        can be designated as primary. You cannot specify this option if you're launching more than one
         *        instance in a <a>RunInstances</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses);

        /**
         * <p>
         * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one
         * private IP address using the private IP addresses option. You cannot specify this option if you're launching
         * more than one instance in a <a>RunInstances</a> request.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses. You can't specify this option and specify more than
         *        one private IP address using the private IP addresses option. You cannot specify this option if you're
         *        launching more than one instance in a <a>RunInstances</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The ID of the subnet associated with the network string. Applies only if creating a network interface when
         * launching an instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet associated with the network string. Applies only if creating a network interface
         *        when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private Boolean deleteOnTermination;

        private String description;

        private Integer deviceIndex;

        private List<String> groups;

        private Integer ipv6AddressCount;

        private List<InstanceIpv6Address> ipv6Addresses;

        private String networkInterfaceId;

        private String privateIpAddress;

        private List<PrivateIpAddressSpecification> privateIpAddresses;

        private Integer secondaryPrivateIpAddressCount;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceSpecification model) {
            setAssociatePublicIpAddress(model.associatePublicIpAddress);
            setDeleteOnTermination(model.deleteOnTermination);
            setDescription(model.description);
            setDeviceIndex(model.deviceIndex);
            setGroups(model.groups);
            setIpv6AddressCount(model.ipv6AddressCount);
            setIpv6Addresses(model.ipv6Addresses);
            setNetworkInterfaceId(model.networkInterfaceId);
            setPrivateIpAddress(model.privateIpAddress);
            setPrivateIpAddresses(model.privateIpAddresses);
            setSecondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            setSubnetId(model.subnetId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final Collection<String> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<InstanceIpv6Address> getIpv6Addresses() {
            return ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<PrivateIpAddressSpecification> getPrivateIpAddresses() {
            return privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public InstanceNetworkInterfaceSpecification build() {
            return new InstanceNetworkInterfaceSpecification(this);
        }
    }
}
