/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Dedicated Host Reservation offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HostOffering implements ToCopyableBuilder<HostOffering.Builder, HostOffering> {
    private final String currencyCode;

    private final Integer duration;

    private final String hourlyPrice;

    private final String instanceFamily;

    private final String offeringId;

    private final String paymentOption;

    private final String upfrontPrice;

    private HostOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    /**
     * <p>
     * The currency of the offering.
     * </p>
     * 
     * @return The currency of the offering.
     * @see CurrencyCodeValues
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The duration of the offering (in seconds).
     * </p>
     * 
     * @return The duration of the offering (in seconds).
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The hourly price of the offering.
     * </p>
     * 
     * @return The hourly price of the offering.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance family of the offering.
     * </p>
     * 
     * @return The instance family of the offering.
     */
    public String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The available payment option.
     * </p>
     * 
     * @return The available payment option.
     * @see PaymentOption
     */
    public String paymentOption() {
        return paymentOption;
    }

    /**
     * <p>
     * The upfront price of the offering. Does not apply to No Upfront offerings.
     * </p>
     * 
     * @return The upfront price of the offering. Does not apply to No Upfront offerings.
     */
    public String upfrontPrice() {
        return upfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((currencyCode() == null) ? 0 : currencyCode().hashCode());
        hashCode = 31 * hashCode + ((duration() == null) ? 0 : duration().hashCode());
        hashCode = 31 * hashCode + ((hourlyPrice() == null) ? 0 : hourlyPrice().hashCode());
        hashCode = 31 * hashCode + ((instanceFamily() == null) ? 0 : instanceFamily().hashCode());
        hashCode = 31 * hashCode + ((offeringId() == null) ? 0 : offeringId().hashCode());
        hashCode = 31 * hashCode + ((paymentOption() == null) ? 0 : paymentOption().hashCode());
        hashCode = 31 * hashCode + ((upfrontPrice() == null) ? 0 : upfrontPrice().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostOffering)) {
            return false;
        }
        HostOffering other = (HostOffering) obj;
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.hourlyPrice() == null ^ this.hourlyPrice() == null) {
            return false;
        }
        if (other.hourlyPrice() != null && !other.hourlyPrice().equals(this.hourlyPrice())) {
            return false;
        }
        if (other.instanceFamily() == null ^ this.instanceFamily() == null) {
            return false;
        }
        if (other.instanceFamily() != null && !other.instanceFamily().equals(this.instanceFamily())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        if (other.paymentOption() == null ^ this.paymentOption() == null) {
            return false;
        }
        if (other.paymentOption() != null && !other.paymentOption().equals(this.paymentOption())) {
            return false;
        }
        if (other.upfrontPrice() == null ^ this.upfrontPrice() == null) {
            return false;
        }
        if (other.upfrontPrice() != null && !other.upfrontPrice().equals(this.upfrontPrice())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (currencyCode() != null) {
            sb.append("CurrencyCode: ").append(currencyCode()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(hourlyPrice()).append(",");
        }
        if (instanceFamily() != null) {
            sb.append("InstanceFamily: ").append(instanceFamily()).append(",");
        }
        if (offeringId() != null) {
            sb.append("OfferingId: ").append(offeringId()).append(",");
        }
        if (paymentOption() != null) {
            sb.append("PaymentOption: ").append(paymentOption()).append(",");
        }
        if (upfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(upfrontPrice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, HostOffering> {
        /**
         * <p>
         * The currency of the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the offering.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the offering.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The duration of the offering (in seconds).
         * </p>
         * 
         * @param duration
         *        The duration of the offering (in seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The hourly price of the offering.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance family of the offering.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The available payment option.
         * </p>
         * 
         * @param paymentOption
         *        The available payment option.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The available payment option.
         * </p>
         * 
         * @param paymentOption
         *        The available payment option.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The upfront price of the offering. Does not apply to No Upfront offerings.
         * </p>
         * 
         * @param upfrontPrice
         *        The upfront price of the offering. Does not apply to No Upfront offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPrice(String upfrontPrice);
    }

    private static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private String hourlyPrice;

        private String instanceFamily;

        private String offeringId;

        private String paymentOption;

        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostOffering model) {
            setCurrencyCode(model.currencyCode);
            setDuration(model.duration);
            setHourlyPrice(model.hourlyPrice);
            setInstanceFamily(model.instanceFamily);
            setOfferingId(model.offeringId);
            setPaymentOption(model.paymentOption);
            setUpfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getUpfrontPrice() {
            return upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        public HostOffering build() {
            return new HostOffering(this);
        }
    }
}
