/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a disk image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiskImage implements ToCopyableBuilder<DiskImage.Builder, DiskImage> {
    private final String description;

    private final DiskImageDetail image;

    private final VolumeDetail volume;

    private DiskImage(BuilderImpl builder) {
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    /**
     * <p>
     * A description of the disk image.
     * </p>
     * 
     * @return A description of the disk image.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Information about the disk image.
     * </p>
     * 
     * @return Information about the disk image.
     */
    public DiskImageDetail image() {
        return image;
    }

    /**
     * <p>
     * Information about the volume.
     * </p>
     * 
     * @return Information about the volume.
     */
    public VolumeDetail volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((image() == null) ? 0 : image().hashCode());
        hashCode = 31 * hashCode + ((volume() == null) ? 0 : volume().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImage)) {
            return false;
        }
        DiskImage other = (DiskImage) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.volume() == null ^ this.volume() == null) {
            return false;
        }
        if (other.volume() != null && !other.volume().equals(this.volume())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (volume() != null) {
            sb.append("Volume: ").append(volume()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DiskImage> {
        /**
         * <p>
         * A description of the disk image.
         * </p>
         * 
         * @param description
         *        A description of the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk image.
         * </p>
         * 
         * @param image
         *        Information about the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(DiskImageDetail image);

        /**
         * <p>
         * Information about the volume.
         * </p>
         * 
         * @param volume
         *        Information about the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(VolumeDetail volume);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private DiskImageDetail image;

        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImage model) {
            setDescription(model.description);
            setImage(model.image);
            setVolume(model.volume);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDetail getImage() {
            return image;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDetail image) {
            this.image = image;
        }

        public final VolumeDetail getVolume() {
            return volume;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(VolumeDetail volume) {
            this.volume = volume;
        }

        @Override
        public DiskImage build() {
            return new DiskImage(this);
        }
    }
}
