/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumesModificationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVolumesModificationsResponse.Builder, DescribeVolumesModificationsResponse> {
    private final List<VolumeModification> volumesModifications;

    private final String nextToken;

    private DescribeVolumesModificationsResponse(BuilderImpl builder) {
        this.volumesModifications = builder.volumesModifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of returned <a>VolumeModification</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of returned <a>VolumeModification</a> objects.
     */
    public List<VolumeModification> volumesModifications() {
        return volumesModifications;
    }

    /**
     * <p>
     * Token for pagination, null if there are no more results
     * </p>
     * 
     * @return Token for pagination, null if there are no more results
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((volumesModifications() == null) ? 0 : volumesModifications().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsResponse)) {
            return false;
        }
        DescribeVolumesModificationsResponse other = (DescribeVolumesModificationsResponse) obj;
        if (other.volumesModifications() == null ^ this.volumesModifications() == null) {
            return false;
        }
        if (other.volumesModifications() != null && !other.volumesModifications().equals(this.volumesModifications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (volumesModifications() != null) {
            sb.append("VolumesModifications: ").append(volumesModifications()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVolumesModificationsResponse> {
        /**
         * <p>
         * A list of returned <a>VolumeModification</a> objects.
         * </p>
         * 
         * @param volumesModifications
         *        A list of returned <a>VolumeModification</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesModifications(Collection<VolumeModification> volumesModifications);

        /**
         * <p>
         * A list of returned <a>VolumeModification</a> objects.
         * </p>
         * 
         * @param volumesModifications
         *        A list of returned <a>VolumeModification</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesModifications(VolumeModification... volumesModifications);

        /**
         * <p>
         * Token for pagination, null if there are no more results
         * </p>
         * 
         * @param nextToken
         *        Token for pagination, null if there are no more results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<VolumeModification> volumesModifications;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsResponse model) {
            setVolumesModifications(model.volumesModifications);
            setNextToken(model.nextToken);
        }

        public final Collection<VolumeModification> getVolumesModifications() {
            return volumesModifications;
        }

        @Override
        public final Builder volumesModifications(Collection<VolumeModification> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copy(volumesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesModifications(VolumeModification... volumesModifications) {
            volumesModifications(Arrays.asList(volumesModifications));
            return this;
        }

        public final void setVolumesModifications(Collection<VolumeModification> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copy(volumesModifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVolumesModificationsResponse build() {
            return new DescribeVolumesModificationsResponse(this);
        }
    }
}
