/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVolumeStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumeStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVolumeStatusResponse.Builder, DescribeVolumeStatusResponse> {
    private final String nextToken;

    private final List<VolumeStatusItem> volumeStatuses;

    private DescribeVolumeStatusResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.volumeStatuses = builder.volumeStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of volumes.
     */
    public List<VolumeStatusItem> volumeStatuses() {
        return volumeStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((volumeStatuses() == null) ? 0 : volumeStatuses().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusResponse)) {
            return false;
        }
        DescribeVolumeStatusResponse other = (DescribeVolumeStatusResponse) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.volumeStatuses() == null ^ this.volumeStatuses() == null) {
            return false;
        }
        if (other.volumeStatuses() != null && !other.volumeStatuses().equals(this.volumeStatuses())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (volumeStatuses() != null) {
            sb.append("VolumeStatuses: ").append(volumeStatuses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVolumeStatusResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of volumes.
         * </p>
         * 
         * @param volumeStatuses
         *        A list of volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses);

        /**
         * <p>
         * A list of volumes.
         * </p>
         * 
         * @param volumeStatuses
         *        A list of volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatuses(VolumeStatusItem... volumeStatuses);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<VolumeStatusItem> volumeStatuses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusResponse model) {
            setNextToken(model.nextToken);
            setVolumeStatuses(model.volumeStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeStatusItem> getVolumeStatuses() {
            return volumeStatuses;
        }

        @Override
        public final Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(VolumeStatusItem... volumeStatuses) {
            volumeStatuses(Arrays.asList(volumeStatuses));
            return this;
        }

        public final void setVolumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
        }

        @Override
        public DescribeVolumeStatusResponse build() {
            return new DescribeVolumeStatusResponse(this);
        }
    }
}
