/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSubnets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSubnetsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeSubnetsRequest.Builder, DescribeSubnetsRequest> {
    private final List<Filter> filters;

    private final List<String> subnetIds;

    private DescribeSubnetsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
     * <code>availability-zone</code> as the filter name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
     * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
     * <code>cidr-block</code> as the filter names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can also
     * use <code>default-for-az</code> as the filter name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
     * with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the subnet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
     *         <code>availability-zone</code> as the filter name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match
     *         the subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code>
     *         or <code>cidr-block</code> as the filter names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You
     *         can also use <code>default-for-az</code> as the filter name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
     *         associated with the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
     *         subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the subnet.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more subnet IDs.
     * </p>
     * <p>
     * Default: Describes all your subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more subnet IDs.</p>
     *         <p>
     *         Default: Describes all your subnets.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((subnetIds() == null) ? 0 : subnetIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetsRequest)) {
            return false;
        }
        DescribeSubnetsRequest other = (DescribeSubnetsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (subnetIds() != null) {
            sb.append("SubnetIds: ").append(subnetIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSubnetsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         * <code>availability-zone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
         * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidr-block</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can
         * also use <code>default-for-az</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         *        <code>availability-zone</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly
         *        match the subnet's CIDR block for information to be returned for the subnet. You can also use
         *        <code>cidr</code> or <code>cidr-block</code> as the filter names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone.
         *        You can also use <code>default-for-az</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
         *        associated with the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the subnet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         * <code>availability-zone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
         * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidr-block</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can
         * also use <code>default-for-az</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         *        <code>availability-zone</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly
         *        match the subnet's CIDR block for information to be returned for the subnet. You can also use
         *        <code>cidr</code> or <code>cidr-block</code> as the filter names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone.
         *        You can also use <code>default-for-az</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
         *        associated with the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the subnet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more subnet IDs.
         * </p>
         * <p>
         * Default: Describes all your subnets.
         * </p>
         * 
         * @param subnetIds
         *        One or more subnet IDs.</p>
         *        <p>
         *        Default: Describes all your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * One or more subnet IDs.
         * </p>
         * <p>
         * Default: Describes all your subnets.
         * </p>
         * 
         * @param subnetIds
         *        One or more subnet IDs.</p>
         *        <p>
         *        Default: Describes all your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> subnetIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetsRequest model) {
            setFilters(model.filters);
            setSubnetIds(model.subnetIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdStringListCopier.copy(subnetIds);
        }

        @Override
        public DescribeSubnetsRequest build() {
            return new DescribeSubnetsRequest(this);
        }
    }
}
