/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotFleetRequestHistory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotFleetRequestHistoryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSpotFleetRequestHistoryResponse.Builder, DescribeSpotFleetRequestHistoryResponse> {
    private final List<HistoryRecord> historyRecords;

    private final Instant lastEvaluatedTime;

    private final String nextToken;

    private final String spotFleetRequestId;

    private final Instant startTime;

    private DescribeSpotFleetRequestHistoryResponse(BuilderImpl builder) {
        this.historyRecords = builder.historyRecords;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * Information about the events in the history of the Spot fleet request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the events in the history of the Spot fleet request.
     */
    public List<HistoryRecord> historyRecords() {
        return historyRecords;
    }

    /**
     * <p>
     * The last date and time for the events, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.
     * </p>
     * <p>
     * If <code>nextToken</code> indicates that there are more results, this value is not present.
     * </p>
     * 
     * @return The last date and time for the events, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were
     *         retrieved.</p>
     *         <p>
     *         If <code>nextToken</code> indicates that there are more results, this value is not present.
     */
    public Instant lastEvaluatedTime() {
        return lastEvaluatedTime;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    /**
     * <p>
     * The starting date and time for the events, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The starting date and time for the events, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((historyRecords() == null) ? 0 : historyRecords().hashCode());
        hashCode = 31 * hashCode + ((lastEvaluatedTime() == null) ? 0 : lastEvaluatedTime().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((spotFleetRequestId() == null) ? 0 : spotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestHistoryResponse)) {
            return false;
        }
        DescribeSpotFleetRequestHistoryResponse other = (DescribeSpotFleetRequestHistoryResponse) obj;
        if (other.historyRecords() == null ^ this.historyRecords() == null) {
            return false;
        }
        if (other.historyRecords() != null && !other.historyRecords().equals(this.historyRecords())) {
            return false;
        }
        if (other.lastEvaluatedTime() == null ^ this.lastEvaluatedTime() == null) {
            return false;
        }
        if (other.lastEvaluatedTime() != null && !other.lastEvaluatedTime().equals(this.lastEvaluatedTime())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (historyRecords() != null) {
            sb.append("HistoryRecords: ").append(historyRecords()).append(",");
        }
        if (lastEvaluatedTime() != null) {
            sb.append("LastEvaluatedTime: ").append(lastEvaluatedTime()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(spotFleetRequestId()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
        /**
         * <p>
         * Information about the events in the history of the Spot fleet request.
         * </p>
         * 
         * @param historyRecords
         *        Information about the events in the history of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historyRecords(Collection<HistoryRecord> historyRecords);

        /**
         * <p>
         * Information about the events in the history of the Spot fleet request.
         * </p>
         * 
         * @param historyRecords
         *        Information about the events in the history of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historyRecords(HistoryRecord... historyRecords);

        /**
         * <p>
         * The last date and time for the events, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.
         * </p>
         * <p>
         * If <code>nextToken</code> indicates that there are more results, this value is not present.
         * </p>
         * 
         * @param lastEvaluatedTime
         *        The last date and time for the events, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were
         *        retrieved.</p>
         *        <p>
         *        If <code>nextToken</code> indicates that there are more results, this value is not present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedTime(Instant lastEvaluatedTime);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);

        /**
         * <p>
         * The starting date and time for the events, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param startTime
         *        The starting date and time for the events, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    private static final class BuilderImpl implements Builder {
        private List<HistoryRecord> historyRecords;

        private Instant lastEvaluatedTime;

        private String nextToken;

        private String spotFleetRequestId;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestHistoryResponse model) {
            setHistoryRecords(model.historyRecords);
            setLastEvaluatedTime(model.lastEvaluatedTime);
            setNextToken(model.nextToken);
            setSpotFleetRequestId(model.spotFleetRequestId);
            setStartTime(model.startTime);
        }

        public final Collection<HistoryRecord> getHistoryRecords() {
            return historyRecords;
        }

        @Override
        public final Builder historyRecords(Collection<HistoryRecord> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copy(historyRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(HistoryRecord... historyRecords) {
            historyRecords(Arrays.asList(historyRecords));
            return this;
        }

        public final void setHistoryRecords(Collection<HistoryRecord> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copy(historyRecords);
        }

        public final Instant getLastEvaluatedTime() {
            return lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final void setLastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public DescribeSpotFleetRequestHistoryResponse build() {
            return new DescribeSpotFleetRequestHistoryResponse(this);
        }
    }
}
