/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotFleetInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotFleetInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSpotFleetInstancesResponse.Builder, DescribeSpotFleetInstancesResponse> {
    private final List<ActiveInstance> activeInstances;

    private final String nextToken;

    private final String spotFleetRequestId;

    private DescribeSpotFleetInstancesResponse(BuilderImpl builder) {
        this.activeInstances = builder.activeInstances;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The running instances. Note that this list is refreshed periodically and might be out of date.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The running instances. Note that this list is refreshed periodically and might be out of date.
     */
    public List<ActiveInstance> activeInstances() {
        return activeInstances;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activeInstances() == null) ? 0 : activeInstances().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((spotFleetRequestId() == null) ? 0 : spotFleetRequestId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesResponse)) {
            return false;
        }
        DescribeSpotFleetInstancesResponse other = (DescribeSpotFleetInstancesResponse) obj;
        if (other.activeInstances() == null ^ this.activeInstances() == null) {
            return false;
        }
        if (other.activeInstances() != null && !other.activeInstances().equals(this.activeInstances())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activeInstances() != null) {
            sb.append("ActiveInstances: ").append(activeInstances()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(spotFleetRequestId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
        /**
         * <p>
         * The running instances. Note that this list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. Note that this list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(Collection<ActiveInstance> activeInstances);

        /**
         * <p>
         * The running instances. Note that this list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. Note that this list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(ActiveInstance... activeInstances);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    private static final class BuilderImpl implements Builder {
        private List<ActiveInstance> activeInstances;

        private String nextToken;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetInstancesResponse model) {
            setActiveInstances(model.activeInstances);
            setNextToken(model.nextToken);
            setSpotFleetRequestId(model.spotFleetRequestId);
        }

        public final Collection<ActiveInstance> getActiveInstances() {
            return activeInstances;
        }

        @Override
        public final Builder activeInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(ActiveInstance... activeInstances) {
            activeInstances(Arrays.asList(activeInstances));
            return this;
        }

        public final void setActiveInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public DescribeSpotFleetInstancesResponse build() {
            return new DescribeSpotFleetInstancesResponse(this);
        }
    }
}
