/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSnapshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSnapshotsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeSnapshotsRequest.Builder, DescribeSnapshotsRequest> {
    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> ownerIds;

    private final List<String> restorableByUserIds;

    private final List<String> snapshotIds;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerIds = builder.ownerIds;
        this.restorableByUserIds = builder.restorableByUserIds;
        this.snapshotIds = builder.snapshotIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>description</code> - A description of the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
     * <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
     * user-configured AWS account alias, which is set from the IAM consolew.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>snapshot-id</code> - The snapshot ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start-time</code> - The time stamp when the snapshot was initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
     * <code>error</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-id</code> - The ID of the volume the snapshot is for.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-size</code> - The size of the volume, in GiB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>description</code> - A description of the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
     *         <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
     *         user-configured AWS account alias, which is set from the IAM consolew.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>snapshot-id</code> - The snapshot ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-time</code> - The time stamp when the snapshot was initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
     *         <code>error</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-id</code> - The ID of the volume the snapshot is for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-size</code> - The size of the volume, in GiB.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output. When this
     * parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results in a single page
     * along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>DescribeSnapshots</code> request with the returned <code>NextToken</code> value. This value
     * can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are
     * returned. If this parameter is not used, then <code>DescribeSnapshots</code> returns all results. You cannot
     * specify this parameter and the snapshot IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output.
     *         When this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results
     *         in a single page along with a <code>NextToken</code> response element. The remaining results of the
     *         initial request can be seen by sending another <code>DescribeSnapshots</code> request with the returned
     *         <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a
     *         value larger than 1000, only 1000 results are returned. If this parameter is not used, then
     *         <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and the snapshot
     *         IDs parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code> request where
     * <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code>
     *         request where <code>MaxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>NextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Returns the snapshots owned by the specified owner. Multiple owners can be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the snapshots owned by the specified owner. Multiple owners can be specified.
     */
    public List<String> ownerIds() {
        return ownerIds;
    }

    /**
     * <p>
     * One or more AWS accounts IDs that can create volumes from the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more AWS accounts IDs that can create volumes from the snapshot.
     */
    public List<String> restorableByUserIds() {
        return restorableByUserIds;
    }

    /**
     * <p>
     * One or more snapshot IDs.
     * </p>
     * <p>
     * Default: Describes snapshots for which you have launch permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more snapshot IDs.</p>
     *         <p>
     *         Default: Describes snapshots for which you have launch permissions.
     */
    public List<String> snapshotIds() {
        return snapshotIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((ownerIds() == null) ? 0 : ownerIds().hashCode());
        hashCode = 31 * hashCode + ((restorableByUserIds() == null) ? 0 : restorableByUserIds().hashCode());
        hashCode = 31 * hashCode + ((snapshotIds() == null) ? 0 : snapshotIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.ownerIds() == null ^ this.ownerIds() == null) {
            return false;
        }
        if (other.ownerIds() != null && !other.ownerIds().equals(this.ownerIds())) {
            return false;
        }
        if (other.restorableByUserIds() == null ^ this.restorableByUserIds() == null) {
            return false;
        }
        if (other.restorableByUserIds() != null && !other.restorableByUserIds().equals(this.restorableByUserIds())) {
            return false;
        }
        if (other.snapshotIds() == null ^ this.snapshotIds() == null) {
            return false;
        }
        if (other.snapshotIds() != null && !other.snapshotIds().equals(this.snapshotIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (ownerIds() != null) {
            sb.append("OwnerIds: ").append(ownerIds()).append(",");
        }
        if (restorableByUserIds() != null) {
            sb.append("RestorableByUserIds: ").append(restorableByUserIds()).append(",");
        }
        if (snapshotIds() != null) {
            sb.append("SnapshotIds: ").append(snapshotIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
         * <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         * user-configured AWS account alias, which is set from the IAM consolew.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - A description of the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
         *        <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         *        user-configured AWS account alias, which is set from the IAM consolew.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time stamp when the snapshot was initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         *        <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume the snapshot is for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
         * <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         * user-configured AWS account alias, which is set from the IAM consolew.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - A description of the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
         *        <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the
         *        user-configured AWS account alias, which is set from the IAM consolew.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time stamp when the snapshot was initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         *        <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume the snapshot is for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output. When
         * this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results in a
         * single page along with a <code>NextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>DescribeSnapshots</code> request with the returned
         * <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a
         * value larger than 1000, only 1000 results are returned. If this parameter is not used, then
         * <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and the snapshot IDs
         * parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output.
         *        When this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code>
         *        results in a single page along with a <code>NextToken</code> response element. The remaining results
         *        of the initial request can be seen by sending another <code>DescribeSnapshots</code> request with the
         *        returned <code>NextToken</code> value. This value can be between 5 and 1000; if
         *        <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this
         *        parameter is not used, then <code>DescribeSnapshots</code> returns all results. You cannot specify
         *        this parameter and the snapshot IDs parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code> request
         * where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>NextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code>
         *        request where <code>MaxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>NextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns the snapshots owned by the specified owner. Multiple owners can be specified.
         * </p>
         * 
         * @param ownerIds
         *        Returns the snapshots owned by the specified owner. Multiple owners can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIds(Collection<String> ownerIds);

        /**
         * <p>
         * Returns the snapshots owned by the specified owner. Multiple owners can be specified.
         * </p>
         * 
         * @param ownerIds
         *        Returns the snapshots owned by the specified owner. Multiple owners can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIds(String... ownerIds);

        /**
         * <p>
         * One or more AWS accounts IDs that can create volumes from the snapshot.
         * </p>
         * 
         * @param restorableByUserIds
         *        One or more AWS accounts IDs that can create volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableByUserIds(Collection<String> restorableByUserIds);

        /**
         * <p>
         * One or more AWS accounts IDs that can create volumes from the snapshot.
         * </p>
         * 
         * @param restorableByUserIds
         *        One or more AWS accounts IDs that can create volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableByUserIds(String... restorableByUserIds);

        /**
         * <p>
         * One or more snapshot IDs.
         * </p>
         * <p>
         * Default: Describes snapshots for which you have launch permissions.
         * </p>
         * 
         * @param snapshotIds
         *        One or more snapshot IDs.</p>
         *        <p>
         *        Default: Describes snapshots for which you have launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(Collection<String> snapshotIds);

        /**
         * <p>
         * One or more snapshot IDs.
         * </p>
         * <p>
         * Default: Describes snapshots for which you have launch permissions.
         * </p>
         * 
         * @param snapshotIds
         *        One or more snapshot IDs.</p>
         *        <p>
         *        Default: Describes snapshots for which you have launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(String... snapshotIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private List<String> ownerIds;

        private List<String> restorableByUserIds;

        private List<String> snapshotIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            setFilters(model.filters);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
            setOwnerIds(model.ownerIds);
            setRestorableByUserIds(model.restorableByUserIds);
            setSnapshotIds(model.snapshotIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getOwnerIds() {
            return ownerIds;
        }

        @Override
        public final Builder ownerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ownerIds(String... ownerIds) {
            ownerIds(Arrays.asList(ownerIds));
            return this;
        }

        public final void setOwnerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
        }

        public final Collection<String> getRestorableByUserIds() {
            return restorableByUserIds;
        }

        @Override
        public final Builder restorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableByUserIds(String... restorableByUserIds) {
            restorableByUserIds(Arrays.asList(restorableByUserIds));
            return this;
        }

        public final void setRestorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
        }

        public final Collection<String> getSnapshotIds() {
            return snapshotIds;
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String... snapshotIds) {
            snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }
    }
}
