/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSnapshotAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSnapshotAttributeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSnapshotAttributeResponse.Builder, DescribeSnapshotAttributeResponse> {
    private final List<CreateVolumePermission> createVolumePermissions;

    private final List<ProductCode> productCodes;

    private final String snapshotId;

    private DescribeSnapshotAttributeResponse(BuilderImpl builder) {
        this.createVolumePermissions = builder.createVolumePermissions;
        this.productCodes = builder.productCodes;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * A list of permissions for creating volumes from the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of permissions for creating volumes from the snapshot.
     */
    public List<CreateVolumePermission> createVolumePermissions() {
        return createVolumePermissions;
    }

    /**
     * <p>
     * A list of product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The ID of the EBS snapshot.
     * </p>
     * 
     * @return The ID of the EBS snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((createVolumePermissions() == null) ? 0 : createVolumePermissions().hashCode());
        hashCode = 31 * hashCode + ((productCodes() == null) ? 0 : productCodes().hashCode());
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotAttributeResponse)) {
            return false;
        }
        DescribeSnapshotAttributeResponse other = (DescribeSnapshotAttributeResponse) obj;
        if (other.createVolumePermissions() == null ^ this.createVolumePermissions() == null) {
            return false;
        }
        if (other.createVolumePermissions() != null && !other.createVolumePermissions().equals(this.createVolumePermissions())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (createVolumePermissions() != null) {
            sb.append("CreateVolumePermissions: ").append(createVolumePermissions()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
        /**
         * <p>
         * A list of permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        A list of permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions);

        /**
         * <p>
         * A list of permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        A list of permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The ID of the EBS snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);
    }

    private static final class BuilderImpl implements Builder {
        private List<CreateVolumePermission> createVolumePermissions;

        private List<ProductCode> productCodes;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotAttributeResponse model) {
            setCreateVolumePermissions(model.createVolumePermissions);
            setProductCodes(model.productCodes);
            setSnapshotId(model.snapshotId);
        }

        public final Collection<CreateVolumePermission> getCreateVolumePermissions() {
            return createVolumePermissions;
        }

        @Override
        public final Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions) {
            createVolumePermissions(Arrays.asList(createVolumePermissions));
            return this;
        }

        public final void setCreateVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
        }

        public final Collection<ProductCode> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public DescribeSnapshotAttributeResponse build() {
            return new DescribeSnapshotAttributeResponse(this);
        }
    }
}
