/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSecurityGroups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSecurityGroupsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSecurityGroupsResponse.Builder, DescribeSecurityGroupsResponse> {
    private final List<SecurityGroup> securityGroups;

    private DescribeSecurityGroupsResponse(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * Information about one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more security groups.
     */
    public List<SecurityGroup> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsResponse)) {
            return false;
        }
        DescribeSecurityGroupsResponse other = (DescribeSecurityGroupsResponse) obj;
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSecurityGroupsResponse> {
        /**
         * <p>
         * Information about one or more security groups.
         * </p>
         * 
         * @param securityGroups
         *        Information about one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroup> securityGroups);

        /**
         * <p>
         * Information about one or more security groups.
         * </p>
         * 
         * @param securityGroups
         *        Information about one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroup... securityGroups);
    }

    private static final class BuilderImpl implements Builder {
        private List<SecurityGroup> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsResponse model) {
            setSecurityGroups(model.securityGroups);
        }

        public final Collection<SecurityGroup> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copy(securityGroups);
        }

        @Override
        public DescribeSecurityGroupsResponse build() {
            return new DescribeSecurityGroupsResponse(this);
        }
    }
}
