/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeRouteTables.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeRouteTablesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeRouteTablesRequest.Builder, DescribeRouteTablesRequest> {
    private final List<Filter> filters;

    private final List<String> routeTableIds;

    private DescribeRouteTablesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.routeTableIds = builder.routeTableIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.route-table-id</code> - The ID of the route table involved in the association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
     * <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in the
     * response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route-table-id</code> - The ID of the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in the
     * table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a
     * route in the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that the
     * route was automatically created when the route table was created; <code>CreateRoute</code> indicates that the
     * route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the route was
     * propagated by route propagation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.state</code> - The state of a route in the route table (<code>active</code> | <code>blackhole</code>
     * ). The blackhole state indicates that the route's target isn't available (for example, the specified gateway
     * isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the
     * table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the route table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.route-table-id</code> - The ID of the route table involved in the association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.subnet-id</code> - The ID of the subnet involved in the association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
     *         <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned
     *         in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route-table-id</code> - The ID of the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route
     *         in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified
     *         in a route in the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates
     *         that the route was automatically created when the route table was created; <code>CreateRoute</code>
     *         indicates that the route was manually added to the route table; <code>EnableVgwRoutePropagation</code>
     *         indicates that the route was propagated by route propagation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.state</code> - The state of a route in the route table (<code>active</code> |
     *         <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for
     *         example, the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated,
     *         and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in
     *         the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the route table.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more route table IDs.
     * </p>
     * <p>
     * Default: Describes all your route tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more route table IDs.</p>
     *         <p>
     *         Default: Describes all your route tables.
     */
    public List<String> routeTableIds() {
        return routeTableIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((routeTableIds() == null) ? 0 : routeTableIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteTablesRequest)) {
            return false;
        }
        DescribeRouteTablesRequest other = (DescribeRouteTablesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.routeTableIds() == null ^ this.routeTableIds() == null) {
            return false;
        }
        if (other.routeTableIds() != null && !other.routeTableIds().equals(this.routeTableIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (routeTableIds() != null) {
            sb.append("RouteTableIds: ").append(routeTableIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeRouteTablesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.route-table-id</code> - The ID of the route table involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
         * <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in
         * the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route-table-id</code> - The ID of the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in
         * the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a
         * route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that
         * the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that
         * the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the
         * route was propagated by route propagation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         * <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for example,
         * the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the route table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.route-table-id</code> - The ID of the route table involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.main</code> - Indicates whether the route table is the main route table for the VPC
         *        (<code>true</code> | <code>false</code>). Route tables that do not have an association ID are not
         *        returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route-table-id</code> - The ID of the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a
         *        route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway
         *        specified in a route in the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code>
         *        indicates that the route was automatically created when the route table was created;
         *        <code>CreateRoute</code> indicates that the route was manually added to the route table;
         *        <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         *        <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for
         *        example, the specified gateway isn't attached to the VPC, the specified NAT instance has been
         *        terminated, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route
         *        in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the route table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.route-table-id</code> - The ID of the route table involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
         * <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in
         * the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route-table-id</code> - The ID of the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in
         * the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a
         * route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that
         * the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that
         * the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the
         * route was propagated by route propagation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         * <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for example,
         * the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the route table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.route-table-id</code> - The ID of the route table involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.main</code> - Indicates whether the route table is the main route table for the VPC
         *        (<code>true</code> | <code>false</code>). Route tables that do not have an association ID are not
         *        returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route-table-id</code> - The ID of the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a
         *        route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway
         *        specified in a route in the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code>
         *        indicates that the route was automatically created when the route table was created;
         *        <code>CreateRoute</code> indicates that the route was manually added to the route table;
         *        <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         *        <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for
         *        example, the specified gateway isn't attached to the VPC, the specified NAT instance has been
         *        terminated, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route
         *        in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the route table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more route table IDs.
         * </p>
         * <p>
         * Default: Describes all your route tables.
         * </p>
         * 
         * @param routeTableIds
         *        One or more route table IDs.</p>
         *        <p>
         *        Default: Describes all your route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(Collection<String> routeTableIds);

        /**
         * <p>
         * One or more route table IDs.
         * </p>
         * <p>
         * Default: Describes all your route tables.
         * </p>
         * 
         * @param routeTableIds
         *        One or more route table IDs.</p>
         *        <p>
         *        Default: Describes all your route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(String... routeTableIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> routeTableIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteTablesRequest model) {
            setFilters(model.filters);
            setRouteTableIds(model.routeTableIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getRouteTableIds() {
            return routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String... routeTableIds) {
            routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        @Override
        public DescribeRouteTablesRequest build() {
            return new DescribeRouteTablesRequest(this);
        }
    }
}
